/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.impl;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import net.sf.jml.Email;
import net.sf.jml.MsnContact;
import net.sf.jml.MsnContactList;
import net.sf.jml.MsnGroup;
import net.sf.jml.MsnList;
import net.sf.jml.MsnMessenger;
import net.sf.jml.impl.MsnGroupImpl;

public class MsnContactListImpl
implements MsnContactList {
    private final MsnMessenger messenger;
    private final MsnGroupImpl defaultGroup;
    private final Map<String, MsnGroup> groupsMap = new LinkedHashMap<String, MsnGroup>();
    private final Map<Email, MsnContact> contactsMap = new LinkedHashMap<Email, MsnContact>();
    private MsnGroup[] groups;
    private MsnContact[] contacts;
    private String version;
    private int contactCount;
    private int groupCount;

    public MsnContactListImpl(MsnMessenger msnMessenger) {
        this.messenger = msnMessenger;
        this.defaultGroup = new MsnGroupImpl(this, true);
        this.defaultGroup.setGroupId("0");
        this.defaultGroup.setGroupName("Default group");
        this.addGroup(this.defaultGroup);
    }

    public MsnMessenger getMessenger() {
        return this.messenger;
    }

    public String getVersion() {
        return this.version;
    }

    public MsnGroup getDefaultGroup() {
        return this.defaultGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MsnGroup[] getGroups() {
        Map<String, MsnGroup> map = this.groupsMap;
        synchronized (map) {
            if (this.groups == null) {
                this.groups = new MsnGroup[this.groupsMap.size()];
                this.groupsMap.values().toArray(this.groups);
            }
            return this.groups;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MsnGroup getGroup(String string) {
        Map<String, MsnGroup> map = this.groupsMap;
        synchronized (map) {
            return this.groupsMap.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MsnContact[] getContacts() {
        Map<Email, MsnContact> map = this.contactsMap;
        synchronized (map) {
            if (this.contacts == null) {
                this.contacts = new MsnContact[this.contactsMap.size()];
                this.contactsMap.values().toArray(this.contacts);
            }
            return this.contacts;
        }
    }

    public MsnContact getContactById(String string) {
        MsnContact[] msnContactArray;
        if (string == null) {
            return null;
        }
        for (MsnContact msnContact : msnContactArray = this.getContacts()) {
            if (!msnContact.getId().equals(string)) continue;
            return msnContact;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MsnContact getContactByEmail(Email email) {
        Map<Email, MsnContact> map = this.contactsMap;
        synchronized (map) {
            return this.contactsMap.get(email);
        }
    }

    public MsnContact[] getContactsInList(MsnList msnList) {
        MsnContact[] msnContactArray;
        if (msnList == null) {
            return new MsnContact[0];
        }
        LinkedList<MsnContact> linkedList = new LinkedList<MsnContact>();
        for (MsnContact msnContact : msnContactArray = this.getContacts()) {
            if (!msnContact.isInList(msnList)) continue;
            linkedList.add(msnContact);
        }
        msnContactArray = new MsnContact[linkedList.size()];
        linkedList.toArray(msnContactArray);
        return msnContactArray;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGroup(MsnGroup msnGroup) {
        if (msnGroup != null && msnGroup.getContactList() == this) {
            Map<String, MsnGroup> map = this.groupsMap;
            synchronized (map) {
                this.groupsMap.put(msnGroup.getGroupId(), msnGroup);
                this.groups = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroup(String string) {
        if (string != null && !string.equals(this.defaultGroup.getGroupId())) {
            Map<String, MsnGroup> map = this.groupsMap;
            synchronized (map) {
                if (this.groupsMap.remove(string) != null) {
                    this.groups = null;
                }
            }
        }
    }

    public void setGroupCount(int n) {
        this.groupCount = n;
    }

    public int getGroupCount() {
        return this.groupCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentGroupCount() {
        Map<String, MsnGroup> map = this.groupsMap;
        synchronized (map) {
            return this.groupsMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContact(MsnContact msnContact) {
        if (msnContact != null && msnContact.getContactList() == this) {
            Map<Email, MsnContact> map = this.contactsMap;
            synchronized (map) {
                this.contactsMap.put(msnContact.getEmail(), msnContact);
                this.contacts = null;
            }
        }
    }

    public void removeContactById(String string) {
        MsnContact msnContact = this.getContactById(string);
        if (msnContact != null) {
            this.removeContactByEmail(msnContact.getEmail());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContactByEmail(Email email) {
        if (email != null) {
            Map<Email, MsnContact> map = this.contactsMap;
            synchronized (map) {
                if (this.contactsMap.remove(email) != null) {
                    this.contacts = null;
                }
            }
        }
    }

    public int getContactCount() {
        return this.contactCount;
    }

    public void setContactCount(int n) {
        this.contactCount = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentContactCount() {
        Map<Email, MsnContact> map = this.contactsMap;
        synchronized (map) {
            return this.contactsMap.size();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("MsnContactList: [GroupCount] ").append(this.groupCount).append(" [ContactCount] ").append(this.contactCount).append("\r\n");
        stringBuffer.append("[Groups]").append("\r\n");
        stringBuffer.append(this.groupsMap.values()).append("\r\n");
        stringBuffer.append("[Contacts]").append("\r\n");
        stringBuffer.append(this.contactsMap.values());
        return stringBuffer.toString();
    }
}

