/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;

public class FileSwitchDirectory
extends Directory {
    private final Directory secondaryDir;
    private final Directory primaryDir;
    private final Set primaryExtensions;
    private boolean doClose;

    public FileSwitchDirectory(Set primaryExtensions, Directory primaryDir, Directory secondaryDir, boolean doClose) {
        this.primaryExtensions = primaryExtensions;
        this.primaryDir = primaryDir;
        this.secondaryDir = secondaryDir;
        this.doClose = doClose;
        this.lockFactory = primaryDir.getLockFactory();
    }

    public Directory getPrimaryDir() {
        return this.primaryDir;
    }

    public Directory getSecondaryDir() {
        return this.secondaryDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.doClose) {
            try {
                this.secondaryDir.close();
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.primaryDir.close();
                throw throwable;
            }
            this.primaryDir.close();
            this.doClose = false;
        }
    }

    public String[] listAll() throws IOException {
        HashSet<String> files = new HashSet<String>();
        files.addAll(Arrays.asList(this.primaryDir.listAll()));
        files.addAll(Arrays.asList(this.secondaryDir.listAll()));
        return files.toArray(new String[files.size()]);
    }

    public String[] list() throws IOException {
        return this.listAll();
    }

    public static String getExtension(String name) {
        int i = name.lastIndexOf(46);
        if (i == -1) {
            return "";
        }
        return name.substring(i + 1, name.length());
    }

    private Directory getDirectory(String name) {
        String ext = FileSwitchDirectory.getExtension(name);
        if (this.primaryExtensions.contains(ext)) {
            return this.primaryDir;
        }
        return this.secondaryDir;
    }

    public boolean fileExists(String name) throws IOException {
        return this.getDirectory(name).fileExists(name);
    }

    public long fileModified(String name) throws IOException {
        return this.getDirectory(name).fileModified(name);
    }

    public void touchFile(String name) throws IOException {
        this.getDirectory(name).touchFile(name);
    }

    public void deleteFile(String name) throws IOException {
        this.getDirectory(name).deleteFile(name);
    }

    public void renameFile(String from, String to) throws IOException {
        this.getDirectory(from).renameFile(from, to);
    }

    public long fileLength(String name) throws IOException {
        return this.getDirectory(name).fileLength(name);
    }

    public IndexOutput createOutput(String name) throws IOException {
        return this.getDirectory(name).createOutput(name);
    }

    public void sync(String name) throws IOException {
        this.getDirectory(name).sync(name);
    }

    public IndexInput openInput(String name) throws IOException {
        return this.getDirectory(name).openInput(name);
    }
}

