/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice;

import org.ice4j.TransportAddress;
import org.ice4j.ice.Candidate;
import org.ice4j.ice.CandidateType;
import org.ice4j.ice.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteCandidate
extends Candidate<RemoteCandidate> {
    private String ufrag = null;

    public RemoteCandidate(TransportAddress transportAddress, Component parentComponent, CandidateType type, String foundation, long priority, RemoteCandidate relatedCandidate) {
        this(transportAddress, parentComponent, type, foundation, priority, relatedCandidate, null);
    }

    public RemoteCandidate(TransportAddress transportAddress, Component parentComponent, CandidateType type, String foundation, long priority, RemoteCandidate relatedCandidate, String ufrag) {
        super(transportAddress, parentComponent, type, relatedCandidate);
        this.setFoundation(foundation);
        this.setPriority(priority);
        this.ufrag = ufrag;
    }

    public void setPriority(long priority) {
        this.priority = priority;
    }

    @Override
    public boolean isDefault() {
        Component parentCmp = this.getParentComponent();
        if (parentCmp == null) {
            return false;
        }
        return this.equals(parentCmp.getDefaultRemoteCandidate());
    }

    @Override
    public String getUfrag() {
        return this.ufrag;
    }

    @Override
    protected RemoteCandidate findRelatedCandidate(TransportAddress relatedAddress) {
        return this.getParentComponent().findRemoteCandidate(relatedAddress);
    }
}

