/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.pt;

import java.util.HashMap;
import java.util.Map;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformer;
import org.jitsi.impl.neomedia.transform.TransformEngine;

public class PayloadTypeTransformEngine
extends SinglePacketTransformer
implements TransformEngine {
    private Map<Byte, Byte> mappingOverrides = new HashMap<Byte, Byte>();
    private Map<Byte, Byte> mappingOverridesCopy = null;

    @Override
    public RawPacket transform(RawPacket pkt) {
        if (this.mappingOverridesCopy == null || this.mappingOverridesCopy.isEmpty()) {
            return pkt;
        }
        Byte newPT = this.mappingOverridesCopy.get(pkt.getPayloadType());
        if (newPT != null) {
            pkt.setPayloadType(newPT);
        }
        return pkt;
    }

    @Override
    public RawPacket reverseTransform(RawPacket pkt) {
        return pkt;
    }

    @Override
    public void close() {
    }

    @Override
    public PacketTransformer getRTPTransformer() {
        return this;
    }

    @Override
    public PacketTransformer getRTCPTransformer() {
        return null;
    }

    public void addPTMappingOverride(byte originalPt, byte overridePt) {
        Byte existingOverride = this.mappingOverrides.get(originalPt);
        if (existingOverride == null || existingOverride != overridePt) {
            this.mappingOverrides.put(originalPt, overridePt);
            this.mappingOverridesCopy = new HashMap<Byte, Byte>(this.mappingOverrides);
        }
    }
}

