/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform;

import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.TransformEngine;

public class TransformEngineChain
implements TransformEngine {
    private final TransformEngine[] engineChain;
    private PacketTransformerChain rtpTransformChain;
    private PacketTransformerChain rtcpTransformChain;

    public TransformEngineChain(TransformEngine[] engineChain) {
        this.engineChain = (TransformEngine[])engineChain.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PacketTransformer getRTPTransformer() {
        TransformEngine[] transformEngineArray = this;
        synchronized (this) {
            boolean invokeOnEngineChain;
            if (this.rtpTransformChain == null) {
                this.rtpTransformChain = (TransformEngineChain)this.new PacketTransformerChain(true);
                invokeOnEngineChain = true;
            } else {
                invokeOnEngineChain = false;
            }
            PacketTransformerChain rtpTransformer = this.rtpTransformChain;
            // ** MonitorExit[var3_1] (shouldn't be in output)
            if (invokeOnEngineChain) {
                for (TransformEngine engine : this.engineChain) {
                    engine.getRTPTransformer();
                }
            }
            return rtpTransformer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PacketTransformer getRTCPTransformer() {
        TransformEngine[] transformEngineArray = this;
        synchronized (this) {
            boolean invokeOnEngineChain;
            if (this.rtcpTransformChain == null) {
                this.rtcpTransformChain = (TransformEngineChain)this.new PacketTransformerChain(false);
                invokeOnEngineChain = true;
            } else {
                invokeOnEngineChain = false;
            }
            PacketTransformerChain rtpTransformer = this.rtcpTransformChain;
            // ** MonitorExit[var3_1] (shouldn't be in output)
            if (invokeOnEngineChain) {
                for (TransformEngine engine : this.engineChain) {
                    engine.getRTCPTransformer();
                }
            }
            return rtpTransformer;
        }
    }

    private class PacketTransformerChain
    implements PacketTransformer {
        private final boolean isRtp;

        public PacketTransformerChain(boolean isRtp) {
            this.isRtp = isRtp;
        }

        @Override
        public void close() {
            for (TransformEngine engine : TransformEngineChain.this.engineChain) {
                PacketTransformer pTransformer;
                PacketTransformer packetTransformer = pTransformer = this.isRtp ? engine.getRTPTransformer() : engine.getRTCPTransformer();
                if (pTransformer == null) continue;
                pTransformer.close();
            }
        }

        @Override
        public RawPacket[] transform(RawPacket[] pkts) {
            for (TransformEngine engine : TransformEngineChain.this.engineChain) {
                PacketTransformer pTransformer;
                PacketTransformer packetTransformer = pTransformer = this.isRtp ? engine.getRTPTransformer() : engine.getRTCPTransformer();
                if (pTransformer == null) continue;
                pkts = pTransformer.transform(pkts);
            }
            return pkts;
        }

        @Override
        public RawPacket[] reverseTransform(RawPacket[] pkts) {
            for (int i = TransformEngineChain.this.engineChain.length - 1; i >= 0; --i) {
                PacketTransformer pTransformer;
                TransformEngine engine = TransformEngineChain.this.engineChain[i];
                PacketTransformer packetTransformer = pTransformer = this.isRtp ? engine.getRTPTransformer() : engine.getRTCPTransformer();
                if (pTransformer == null) continue;
                pkts = pTransformer.reverseTransform(pkts);
            }
            return pkts;
        }
    }
}

