/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.device;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Format;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.MediaServiceImpl;
import org.jitsi.impl.neomedia.device.AudioSystem;
import org.jitsi.impl.neomedia.device.CaptureDeviceInfo2;
import org.jitsi.impl.neomedia.device.Devices;

public class CaptureDevices
extends Devices {
    public static final String PROP_DEVICE = "captureDevice";

    public CaptureDevices(AudioSystem audioSystem) {
        super(audioSystem);
    }

    @Override
    public List<CaptureDeviceInfo2> getDevices() {
        List<CaptureDeviceInfo2> devices = super.getDevices();
        if (!devices.isEmpty()) {
            ArrayList<CaptureDeviceInfo2> thisDevices = new ArrayList<CaptureDeviceInfo2>(devices.size());
            AudioFormat format = new AudioFormat("LINEAR", -1.0, 16, -1);
            block0: for (CaptureDeviceInfo2 device : devices) {
                for (Format deviceFormat : device.getFormats()) {
                    if (!deviceFormat.matches(format)) continue;
                    thisDevices.add(device);
                    continue block0;
                }
            }
            devices = thisDevices;
        }
        return devices;
    }

    @Override
    protected String getPropDevice() {
        return PROP_DEVICE;
    }

    @Override
    public void setDevices(List<CaptureDeviceInfo2> devices) {
        super.setDevices(devices);
        if (devices != null) {
            boolean commit = false;
            for (CaptureDeviceInfo captureDeviceInfo : devices) {
                CaptureDeviceManager.addDevice(captureDeviceInfo);
                commit = true;
            }
            if (commit && !MediaServiceImpl.isJmfRegistryDisableLoad()) {
                try {
                    CaptureDeviceManager.commit();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

