/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.util;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FocusAccountFactory {
    private FocusAccountFactory() {
    }

    public static Map<String, String> createFocusAccountProperties(String serverAddress, String domain, String userName) {
        HashMap<String, String> properties = new HashMap<String, String>();
        String resource = userName + System.nanoTime();
        String userID = userName + "@" + domain + "/" + resource;
        properties.put("USER_ID", userID);
        properties.put("SERVER_ADDRESS", serverAddress);
        properties.put("SERVER_PORT", "5222");
        properties.put("ACCOUNT_DISPLAY_NAME", userName);
        properties.put("RESOURCE", resource);
        properties.put("RESOURCE_PRIORITY", "30");
        properties.put("ANONYMOUS_AUTH", "true");
        properties.put("CARBON_DISABLED", "true");
        properties.put("DEFAULT_ENCRYPTION", "true");
        properties.put("DEFAULT_SIPZRTP_ATTRIBUTE", "false");
        properties.put("ENCRYPTION_PROTOCOL_STATUS.DTLS-SRTP", "true");
        properties.put("ICE_ENABLED", "true");
        properties.put("GTALK_ICE_ENABLED", "true");
        properties.put("IS_ACCOUNT_DISABLED", "false");
        properties.put("IS_PREFERRED_PROTOCOL", "false");
        properties.put("IS_SERVER_OVERRIDDEN", "false");
        properties.put("AUTO_DISCOVER_JINGLE_NODES", "false");
        properties.put("PROTOCOL_NAME", "Jabber");
        properties.put("UPNP_ENABLED", "false");
        properties.put("USE_DEFAULT_STUN_SERVER", "true");
        properties.put("Encodings.G722/8000", "700");
        properties.put("Encodings.GSM/8000", "0");
        properties.put("Encodings.H263-1998/90000", "0");
        properties.put("Encodings.H264/90000", "0");
        properties.put("Encodings.PCMA/8000", "600");
        properties.put("Encodings.PCMU/8000", "650");
        properties.put("Encodings.SILK/12000", "0");
        properties.put("Encodings.SILK/16000", "0");
        properties.put("Encodings.SILK/24000", "0");
        properties.put("Encodings.SILK/8000", "0");
        properties.put("Encodings.VP8/90000", "100");
        properties.put("Encodings.iLBC/8000", "10");
        properties.put("Encodings.opus/48000", "1000");
        properties.put("Encodings.red/90000", "0");
        properties.put("Encodings.speex/16000", "0");
        properties.put("Encodings.speex/32000", "0");
        properties.put("Encodings.speex/8000", "0");
        properties.put("Encodings.telephone-event/8000", "0");
        properties.put("Encodings.ulpfec/90000", "0");
        properties.put("G722/8000", "0");
        properties.put("GSM/8000", "0");
        properties.put("H263-1998/90000", "0");
        properties.put("H264/90000", "0");
        properties.put("OVERRIDE_ENCODINGS", "true");
        return properties;
    }

    public static Map<String, String> createFocusAccountProperties(String serverAddress, String domain, String userName, String password) {
        Map<String, String> properties = FocusAccountFactory.createFocusAccountProperties(serverAddress, domain, userName);
        properties.put("AUTHORIZATION_NAME", userName);
        properties.put("PASSWORD", password);
        properties.put("ANONYMOUS_AUTH", "false");
        return properties;
    }
}

