/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriStatsExtension;
import net.java.sip.communicator.util.Logger;
import org.jitsi.jicofo.FocusBundleActivator;
import org.jitsi.protocol.xmpp.OperationSetSubscription;
import org.jitsi.protocol.xmpp.SubscriptionListener;
import org.jitsi.util.StringUtils;
import org.jivesoftware.smack.packet.PacketExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BridgeSelector
implements SubscriptionListener {
    private static final Logger logger = Logger.getLogger(BridgeSelector.class);
    public static final String BRIDGE_TO_PUBSUB_PNAME = "org.jitsi.focus.BRIDGE_PUBSUB_MAPPING";
    private final OperationSetSubscription subscriptionOpSet;
    private Map<String, BridgeState> bridges = new HashMap<String, BridgeState>();
    private Map<String, String> pubSubToBridge = new HashMap<String, String>();

    public BridgeSelector(OperationSetSubscription subscriptionOpSet) {
        String[] pairs;
        this.subscriptionOpSet = subscriptionOpSet;
        String mappingPropertyValue = FocusBundleActivator.getConfigService().getString(BRIDGE_TO_PUBSUB_PNAME);
        if (StringUtils.isNullOrEmpty((String)mappingPropertyValue)) {
            return;
        }
        for (String pair : pairs = mappingPropertyValue.split(";")) {
            String[] bridgeAndNode = pair.split(":");
            String bridge = bridgeAndNode[0];
            String pubSubNode = bridgeAndNode[1];
            this.pubSubToBridge.put(pubSubNode, bridge);
            logger.info((Object)("Pub-sub mapping: " + pubSubNode + " -> " + bridge));
        }
    }

    public void addJvbAddress(String bridgeJid) {
        String pubSubNode = this.findNodeForBridge(bridgeJid);
        if (pubSubNode != null) {
            logger.info((Object)("Subscribing to pubsub notfications to " + pubSubNode + " for " + bridgeJid));
            this.subscriptionOpSet.subscribe(pubSubNode, this);
        } else {
            logger.warn((Object)("No pub-sub node mapped for " + bridgeJid + " statistics will not be tracked fro this instance."));
        }
        this.bridges.put(bridgeJid, new BridgeState(bridgeJid));
    }

    public String selectVideobridge() {
        if (this.bridges.size() == 0) {
            return null;
        }
        Iterator<BridgeState> bridgesIter = this.bridges.values().iterator();
        BridgeState bestChoice = bridgesIter.next();
        while (bridgesIter.hasNext()) {
            BridgeState candidate = bridgesIter.next();
            if (candidate.compareTo(bestChoice) >= 0) continue;
            bestChoice = candidate;
        }
        return bestChoice.isOperational ? bestChoice.jid : null;
    }

    public List<String> getPrioritizedBridgesList() {
        ArrayList<BridgeState> bridgeList = new ArrayList<BridgeState>(this.bridges.values());
        Collections.sort(bridgeList);
        ArrayList<String> bridgeJidList = new ArrayList<String>();
        for (BridgeState bridgeState : bridgeList) {
            bridgeJidList.add(bridgeState.jid);
        }
        return bridgeJidList;
    }

    public void updateBridgeOperationalStatus(String bridgeJid, boolean isWorking) {
        BridgeState bridge = this.bridges.get(bridgeJid);
        if (bridge != null) {
            bridge.setIsOperational(isWorking);
        } else {
            logger.warn((Object)("No bridge registered for jid: " + bridgeJid));
        }
    }

    public String getBridgeForPubSubNode(String pubSubNode) {
        BridgeState bridge = this.findBridgeForNode(pubSubNode);
        return bridge != null ? bridge.jid : null;
    }

    private BridgeState findBridgeForNode(String pubSubNode) {
        String bridgeJid = this.pubSubToBridge.get(pubSubNode);
        if (bridgeJid != null) {
            return this.bridges.get(bridgeJid);
        }
        return null;
    }

    private String findNodeForBridge(String bridgeJid) {
        for (Map.Entry<String, String> psNodeToBridge : this.pubSubToBridge.entrySet()) {
            if (!psNodeToBridge.getValue().equals(bridgeJid)) continue;
            return psNodeToBridge.getKey();
        }
        return null;
    }

    @Override
    public void onSubscriptionUpdate(String node, PacketExtension payload) {
        if (!(payload instanceof ColibriStatsExtension)) {
            logger.error((Object)("Unexpected pub-sub notification payload: " + payload.getClass().getName()));
            return;
        }
        BridgeState bridgeState = this.findBridgeForNode(node);
        if (bridgeState == null) {
            logger.warn((Object)("No bridge registered or missing mapping for node: " + node));
            return;
        }
        ColibriStatsExtension stats = (ColibriStatsExtension)payload;
        for (PacketExtension child : stats.getChildExtensions()) {
            ColibriStatsExtension.Stat stat;
            if (!(child instanceof ColibriStatsExtension.Stat) || !"conferences".equals((stat = (ColibriStatsExtension.Stat)child).getName())) continue;
            Object statValue = stat.getValue();
            if (statValue == null) {
                return;
            }
            String stringStatValue = String.valueOf(statValue);
            try {
                bridgeState.setConferenceCount(Integer.parseInt(stringStatValue));
            }
            catch (NumberFormatException e) {
                logger.error((Object)("Error parsing conference count stat: " + stringStatValue));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BridgeState
    implements Comparable<BridgeState> {
        private final String jid;
        private int conferenceCount = Integer.MAX_VALUE;
        private boolean isOperational = true;

        BridgeState(String bridgeJid) {
            if (StringUtils.isNullOrEmpty((String)bridgeJid)) {
                throw new NullPointerException("bridgeJid");
            }
            this.jid = bridgeJid;
        }

        public void setConferenceCount(int conferenceCount) {
            if (this.conferenceCount != conferenceCount) {
                logger.info((Object)("Conference count for: " + this.jid + ": " + conferenceCount));
            }
            this.conferenceCount = conferenceCount;
        }

        public int getConferenceCount() {
            return this.conferenceCount;
        }

        public void setIsOperational(boolean isOperational) {
            this.isOperational = isOperational;
        }

        @Override
        public int compareTo(BridgeState o) {
            if (this.isOperational && !o.isOperational) {
                return -1;
            }
            if (!this.isOperational && o.isOperational) {
                return 1;
            }
            return this.conferenceCount - o.conferenceCount;
        }
    }
}

