/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.protocol.xmpp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import net.java.sip.communicator.impl.protocol.jabber.ChatRoomJabberImpl;
import net.java.sip.communicator.service.protocol.AbstractChatRoom;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.ChatRoomConfigurationForm;
import net.java.sip.communicator.service.protocol.ChatRoomMember;
import net.java.sip.communicator.service.protocol.ChatRoomMemberRole;
import net.java.sip.communicator.service.protocol.ConferenceDescription;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.Message;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.ChatRoomLocalUserRoleChangeEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomLocalUserRoleListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberPresenceChangeEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberPresenceListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberPropertyChangeListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberRoleListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomPropertyChangeListener;
import net.java.sip.communicator.util.Logger;
import org.jitsi.impl.protocol.xmpp.ChatMemberImpl;
import org.jitsi.impl.protocol.xmpp.OperationSetMultiUserChatImpl;
import org.jitsi.util.StringUtils;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.FormField;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.Occupant;
import org.jivesoftware.smackx.muc.ParticipantStatusListener;
import org.jivesoftware.smackx.packet.MUCUser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChatRoomImpl
extends AbstractChatRoom {
    private static final Logger logger = Logger.getLogger(ChatRoomImpl.class);
    private final OperationSetMultiUserChatImpl opSet;
    private final String roomName;
    private MultiUserChat muc;
    private String myNickName;
    private CopyOnWriteArrayList<ChatRoomMemberPresenceListener> listeners = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<ChatRoomLocalUserRoleListener> localUserRoleListeners = new CopyOnWriteArrayList();
    private final Map<String, ChatMemberImpl> members = new HashMap<String, ChatMemberImpl>();
    private ChatRoomMemberRole role;

    public ChatRoomImpl(OperationSetMultiUserChatImpl parentChatOperationSet, String roomName) {
        this.opSet = parentChatOperationSet;
        this.roomName = roomName;
        this.muc = new MultiUserChat(parentChatOperationSet.getConnection(), roomName);
        this.muc.addParticipantStatusListener((ParticipantStatusListener)new MemberListener());
        this.muc.addParticipantListener((PacketListener)new ParticipantListener());
    }

    public String getName() {
        return this.roomName;
    }

    public String getIdentifier() {
        return null;
    }

    public void join() throws OperationFailedException {
        this.joinAs(this.getParentProvider().getAccountID().getAccountDisplayName());
    }

    public void join(byte[] password) throws OperationFailedException {
        this.join();
    }

    public void joinAs(String nickname) throws OperationFailedException {
        try {
            this.muc.create(nickname);
            this.myNickName = nickname;
            Form config = this.muc.getConfigurationForm();
            Form answer = config.createAnswerForm();
            FormField whois = new FormField("muc#roomconfig_whois");
            whois.addValue("anyone");
            answer.addField(whois);
            this.muc.sendConfigurationForm(answer);
        }
        catch (XMPPException e) {
            throw new OperationFailedException("Failed to join the room", 1, (Throwable)e);
        }
    }

    public void joinAs(String nickname, byte[] password) throws OperationFailedException {
        this.joinAs(nickname);
    }

    public boolean isJoined() {
        return this.muc.isJoined();
    }

    public void leave() {
        this.muc.leave();
    }

    public String getSubject() {
        return this.muc.getSubject();
    }

    public void setSubject(String subject) throws OperationFailedException {
    }

    public String getUserNickname() {
        return this.myNickName;
    }

    public ChatRoomMemberRole getUserRole() {
        if (this.role == null) {
            Occupant o = this.muc.getOccupant(this.muc.getRoom() + "/" + this.muc.getNickname());
            if (o == null) {
                return ChatRoomMemberRole.GUEST;
            }
            this.role = ChatRoomJabberImpl.smackRoleToScRole((String)o.getRole(), (String)o.getAffiliation());
        }
        return this.role;
    }

    public void setLocalUserRole(ChatRoomMemberRole role) throws OperationFailedException {
    }

    private void fireLocalUserRoleEvent(ChatRoomMemberRole previousRole, ChatRoomMemberRole newRole, boolean isInitial) {
        ChatRoomLocalUserRoleChangeEvent evt = new ChatRoomLocalUserRoleChangeEvent((ChatRoom)this, previousRole, newRole, isInitial);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Will dispatch the following ChatRoom event: " + evt));
        }
        for (ChatRoomLocalUserRoleListener listener : this.localUserRoleListeners) {
            listener.localUserRoleChanged(evt);
        }
    }

    public void setLocalUserRole(ChatRoomMemberRole role, boolean isInitial) {
        this.fireLocalUserRoleEvent(this.getUserRole(), role, isInitial);
        this.role = role;
    }

    public void setUserNickname(String nickname) throws OperationFailedException {
    }

    public void addMemberPresenceListener(ChatRoomMemberPresenceListener listener) {
        this.listeners.add(listener);
    }

    public void removeMemberPresenceListener(ChatRoomMemberPresenceListener listener) {
        this.listeners.remove(listener);
    }

    public void addLocalUserRoleListener(ChatRoomLocalUserRoleListener listener) {
        this.localUserRoleListeners.add(listener);
    }

    public void removelocalUserRoleListener(ChatRoomLocalUserRoleListener listener) {
        this.localUserRoleListeners.remove(listener);
    }

    public void addMemberRoleListener(ChatRoomMemberRoleListener listener) {
    }

    public void removeMemberRoleListener(ChatRoomMemberRoleListener listener) {
    }

    public void addPropertyChangeListener(ChatRoomPropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(ChatRoomPropertyChangeListener listener) {
    }

    public void addMemberPropertyChangeListener(ChatRoomMemberPropertyChangeListener listener) {
    }

    public void removeMemberPropertyChangeListener(ChatRoomMemberPropertyChangeListener listener) {
    }

    public void invite(String userAddress, String reason) {
    }

    public List<ChatRoomMember> getMembers() {
        return new ArrayList<ChatRoomMember>(this.members.values());
    }

    public int getMembersCount() {
        return this.muc.getOccupantsCount();
    }

    public void addMessageListener(ChatRoomMessageListener listener) {
    }

    public void removeMessageListener(ChatRoomMessageListener listener) {
    }

    public Message createMessage(byte[] content, String contentType, String contentEncoding, String subject) {
        return null;
    }

    public Message createMessage(String messageText) {
        return null;
    }

    public void sendMessage(Message message) throws OperationFailedException {
    }

    public ProtocolProviderService getParentProvider() {
        return this.opSet.getProtocolProvider();
    }

    public Iterator<ChatRoomMember> getBanList() throws OperationFailedException {
        return null;
    }

    public void banParticipant(ChatRoomMember chatRoomMember, String reason) throws OperationFailedException {
    }

    public void kickParticipant(ChatRoomMember chatRoomMember, String reason) throws OperationFailedException {
    }

    public ChatRoomConfigurationForm getConfigurationForm() throws OperationFailedException {
        return null;
    }

    public boolean isSystem() {
        return false;
    }

    public boolean isPersistent() {
        return false;
    }

    public Contact getPrivateContactByNickname(String name) {
        return null;
    }

    public void grantAdmin(String address) {
        try {
            this.muc.grantAdmin(address);
        }
        catch (XMPPException e) {
            throw new RuntimeException(e);
        }
    }

    public void grantMembership(String address) {
        try {
            this.muc.grantMembership(address);
        }
        catch (XMPPException e) {
            throw new RuntimeException(e);
        }
    }

    public void grantModerator(String nickname) {
        try {
            this.muc.grantModerator(nickname);
        }
        catch (XMPPException e) {
            throw new RuntimeException(e);
        }
    }

    public void grantOwnership(String address) {
        try {
            this.muc.grantOwnership(address);
        }
        catch (XMPPException e) {
            throw new RuntimeException(e);
        }
    }

    public void grantVoice(String nickname) {
    }

    public void revokeAdmin(String address) {
    }

    public void revokeMembership(String address) {
    }

    public void revokeModerator(String nickname) {
    }

    public void revokeOwnership(String address) {
    }

    public void revokeVoice(String nickname) {
    }

    public ConferenceDescription publishConference(ConferenceDescription cd, String name) {
        return null;
    }

    public void updatePrivateContactPresenceStatus(String nickname) {
    }

    public void updatePrivateContactPresenceStatus(Contact contact) {
    }

    public boolean destroy(String reason, String alternateAddress) {
        try {
            this.muc.destroy(reason, alternateAddress);
        }
        catch (XMPPException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    public List<String> getMembersWhiteList() {
        return null;
    }

    public void setMembersWhiteList(List<String> members) {
    }

    private void notifyParticipantJoined(ChatMemberImpl member) {
        ChatRoomMemberPresenceChangeEvent event = new ChatRoomMemberPresenceChangeEvent((ChatRoom)this, (ChatRoomMember)member, "MemberJoined", null);
        for (ChatRoomMemberPresenceListener l : this.listeners) {
            l.memberPresenceChanged(event);
        }
    }

    private void notifyParticipantLeft(ChatMemberImpl member) {
        ChatRoomMemberPresenceChangeEvent event = new ChatRoomMemberPresenceChangeEvent((ChatRoom)this, (ChatRoomMember)member, "MemberLeft", null);
        for (ChatRoomMemberPresenceListener l : this.listeners) {
            l.memberPresenceChanged(event);
        }
    }

    private void notifyParticipantKicked(ChatMemberImpl member) {
        ChatRoomMemberPresenceChangeEvent event = new ChatRoomMemberPresenceChangeEvent((ChatRoom)this, (ChatRoomMember)member, "MemberKicked", null);
        for (ChatRoomMemberPresenceListener l : this.listeners) {
            l.memberPresenceChanged(event);
        }
    }

    public Occupant getOccupant(ChatMemberImpl chatMemeber) {
        return this.muc.getOccupant(chatMemeber.getContactAddress());
    }

    private MUCUser getMUCUserExtension(Packet packet) {
        if (packet != null) {
            return (MUCUser)packet.getExtension("x", "http://jabber.org/protocol/muc#user");
        }
        return null;
    }

    class ParticipantListener
    implements PacketListener {
        ParticipantListener() {
        }

        public void processPacket(Packet packet) {
            if (packet == null || !(packet instanceof Presence) || packet.getError() != null) {
                logger.warn((Object)("Unable to handle packet: " + packet));
                return;
            }
            Presence presence = (Presence)packet;
            String ourOccupantJid = ChatRoomImpl.this.muc.getRoom() + "/" + ChatRoomImpl.this.muc.getNickname();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Presence received " + presence.toXML()));
            }
            if (ourOccupantJid.equals(presence.getFrom())) {
                this.processOwnPresence(presence);
            } else {
                this.processOtherPresence(presence);
            }
        }

        private void processOwnPresence(Presence presence) {
            MUCUser mucUser = ChatRoomImpl.this.getMUCUserExtension((Packet)presence);
            if (mucUser != null) {
                String affiliation = mucUser.getItem().getAffiliation();
                String role = mucUser.getItem().getRole();
                ChatRoomMemberRole jitsiRole = ChatRoomJabberImpl.smackRoleToScRole((String)role, (String)affiliation);
                ChatRoomImpl.this.setLocalUserRole(jitsiRole, true);
            }
        }

        private void processOtherPresence(Presence presence) {
            MUCUser mucUser = (MUCUser)presence.getExtension("x", "http://jabber.org/protocol/muc#user");
            ChatMemberImpl member = (ChatMemberImpl)ChatRoomImpl.this.members.get(presence.getFrom());
            if (member == null) {
                logger.warn((Object)("Received presence for non-existing member: " + presence.toXML()));
                return;
            }
            String jid = mucUser.getItem().getJid();
            if (StringUtils.isNullOrEmpty((String)member.getJabberID())) {
                logger.info((Object)("JID: " + jid + " received for: " + member.getContactAddress()));
                member.setJabberID(mucUser.getItem().getJid());
            } else if (!jid.equals(member.getJabberID())) {
                logger.warn((Object)("New jid received in presence: " + presence.toXML()));
            }
        }
    }

    class MemberListener
    implements ParticipantStatusListener {
        MemberListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void joined(String participant) {
            ChatMemberImpl member;
            Map map = ChatRoomImpl.this.members;
            synchronized (map) {
                member = this.addMember(participant);
            }
            if (member != null) {
                ChatRoomImpl.this.notifyParticipantJoined(member);
            }
        }

        private ChatMemberImpl addMember(String participant) {
            if (ChatRoomImpl.this.members.containsKey(participant)) {
                logger.error((Object)(participant + " already in " + ChatRoomImpl.this.roomName));
                return null;
            }
            ChatMemberImpl newMember = new ChatMemberImpl(participant, ChatRoomImpl.this);
            ChatRoomImpl.this.members.put(participant, newMember);
            return newMember;
        }

        private ChatMemberImpl removeMember(String participant) {
            ChatMemberImpl removed = (ChatMemberImpl)ChatRoomImpl.this.members.remove(participant);
            if (removed == null) {
                logger.error((Object)(participant + " not in " + ChatRoomImpl.this.roomName));
            }
            return removed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void left(String participant) {
            ChatMemberImpl member;
            Map map = ChatRoomImpl.this.members;
            synchronized (map) {
                member = this.removeMember(participant);
            }
            if (member != null) {
                ChatRoomImpl.this.notifyParticipantLeft(member);
            }
        }

        public void kicked(String participant, String s2, String s3) {
            ChatMemberImpl member;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Kicked: " + participant + ", " + s2 + ", " + s3));
            }
            if ((member = (ChatMemberImpl)ChatRoomImpl.this.members.get(participant)) == null) {
                logger.error((Object)("Kicked participant does not exist: " + participant));
                return;
            }
            ChatRoomImpl.this.notifyParticipantKicked(member);
        }

        public void voiceGranted(String s) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Voice granted: " + s));
            }
        }

        public void voiceRevoked(String s) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Voice revoked: " + s));
            }
        }

        public void banned(String s, String s2, String s3) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Banned: " + s + ", " + s2 + ", " + s3));
            }
        }

        public void membershipGranted(String s) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Membership granted: " + s));
            }
        }

        public void membershipRevoked(String s) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Membership revoked: " + s));
            }
        }

        public void moderatorGranted(String s) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Moderator granted: " + s));
            }
        }

        public void moderatorRevoked(String s) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Moderator revoked: " + s));
            }
        }

        public void ownershipGranted(String s) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Ownership granted: " + s));
            }
        }

        public void ownershipRevoked(String s) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Ownership revoked: " + s));
            }
        }

        public void adminGranted(String s) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Admin granted: " + s));
            }
        }

        public void adminRevoked(String s) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Admin revoked: " + s));
            }
        }

        public void nicknameChanged(String oldNickname, String newNickname) {
            logger.error((Object)"nicknameChanged - NOT IMPLEMENTED");
        }
    }
}

