/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.simulcast;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.util.Logger;
import org.jitsi.util.StringUtils;
import org.jitsi.util.event.WeakReferencePropertyChangeListener;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.RtpChannel;
import org.jitsi.videobridge.SctpConnection;
import org.jitsi.videobridge.VideoChannel;
import org.jitsi.videobridge.simulcast.SimulcastLayer;
import org.jitsi.videobridge.simulcast.SimulcastManager;
import org.jitsi.videobridge.simulcast.SimulcastReceiverOptions;
import org.jitsi.videobridge.simulcast.StringCompiler;
import org.jitsi.videobridge.simulcast.messages.EndpointSimulcastLayer;
import org.jitsi.videobridge.simulcast.messages.SimulcastLayersChangedEvent;
import org.jitsi.videobridge.simulcast.messages.SimulcastLayersChangingEvent;
import org.jitsi.videobridge.simulcast.messages.SimulcastMessagesMapper;
import org.jitsi.videobridge.simulcast.messages.StartSimulcastLayerCommand;
import org.jitsi.videobridge.simulcast.messages.StopSimulcastLayerCommand;

class SimulcastReceiver
implements PropertyChangeListener {
    protected static final SimulcastReceiverOptions initOptions;
    private static final Logger logger;
    private static final SimulcastMessagesMapper mapper;
    private static final int MAX_NEXT_SEEN = 125;
    private final SimulcastManager mySM;
    private final Object receiveLayersSyncRoot = new Object();
    private int seenNext;
    private WeakReference<SimulcastLayer> weakCurrent;
    private WeakReference<SimulcastLayer> weakNext;
    private WeakReference<SimulcastLayer> weakOverride;
    private final WeakReference<SimulcastManager> weakPeerSM;
    private final PropertyChangeListener weakPropertyChangeListener = new WeakReferencePropertyChangeListener((PropertyChangeListener)this);

    public SimulcastReceiver(SimulcastManager mySM, SimulcastManager peerSM) {
        this.weakPeerSM = new WeakReference<SimulcastManager>(peerSM);
        this.mySM = mySM;
        peerSM.addPropertyChangeListener(this.weakPropertyChangeListener);
        this.onPeerLayersChanged(peerSM);
        mySM.getVideoChannel().addPropertyChangeListener(this.weakPropertyChangeListener);
        Endpoint self = this.getSelf();
        this.onEndpointChanged(self, null);
    }

    public boolean accept(long ssrc) {
        SimulcastLayer override;
        SimulcastLayer next;
        SimulcastLayer current = this.getCurrent();
        boolean accept = false;
        if (current != null) {
            accept = current.accept(ssrc);
        }
        if (!accept && (next = this.getNext()) != null && (accept = next.accept(ssrc))) {
            this.maybeSwitchToNext();
        }
        if ((override = this.getOverride()) != null) {
            accept = override.accept(ssrc);
        }
        return accept;
    }

    private void askForKeyframe(SimulcastLayer layer) {
        if (layer == null) {
            logger.warn((Object)"Requested a key frame for null layer!");
            return;
        }
        SimulcastManager peerSM = this.getPeerSM();
        if (peerSM == null) {
            logger.warn((Object)"Requested a key frame but the peer simulcast manager is null!");
            return;
        }
        peerSM.getVideoChannel().askForKeyframes(new int[]{(int)layer.getPrimarySSRC()});
        if (logger.isDebugEnabled()) {
            HashMap<String, Object> map = new HashMap<String, Object>(3);
            map.put("self", this.getSelf());
            map.put("peer", this.getPeer());
            map.put("layer", layer);
            StringCompiler sc = new StringCompiler(map);
            logger.debug((Object)sc.c("The simulcast receiver of {self.id} for {peer.id} has asked for a key frame for layer {layer.order} ({layer.primarySSRC})."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configure(SimulcastReceiverOptions options) {
        Object object = this.receiveLayersSyncRoot;
        synchronized (object) {
            this.maybeConfigureOverride(options);
            this.maybeConfigureNext(options);
        }
    }

    private SimulcastLayer getCurrent() {
        WeakReference<SimulcastLayer> wr = this.weakCurrent;
        return wr != null ? (SimulcastLayer)wr.get() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getIncomingBitrate(boolean noOverride) {
        long bitrate = 0L;
        if (!noOverride) {
            Object object = this.receiveLayersSyncRoot;
            synchronized (object) {
                SimulcastLayer override = this.getOverride();
                if (override != null) {
                    bitrate = override.getBitrate();
                } else {
                    SimulcastLayer current = this.getCurrent();
                    if (current != null) {
                        bitrate = current.getBitrate();
                    }
                }
            }
        } else {
            SimulcastLayer current = this.getCurrent();
            if (current != null) {
                bitrate = current.getBitrate();
            }
        }
        return bitrate;
    }

    private SimulcastLayer getNext() {
        WeakReference<SimulcastLayer> wr = this.weakNext;
        return wr != null ? (SimulcastLayer)wr.get() : null;
    }

    private SimulcastLayer getOverride() {
        WeakReference<SimulcastLayer> wr = this.weakOverride;
        return wr != null ? (SimulcastLayer)wr.get() : null;
    }

    private Endpoint getPeer() {
        VideoChannel vc;
        Endpoint peer;
        SimulcastManager sm = this.getPeerSM();
        Endpoint endpoint = peer = sm != null && (vc = sm.getVideoChannel()) != null ? vc.getEndpoint() : null;
        if (peer == null) {
            logger.warn((Object)"Peer is null!");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)Arrays.toString(Thread.currentThread().getStackTrace()));
            }
        }
        return peer;
    }

    private SimulcastManager getPeerSM() {
        SimulcastManager peerSM;
        WeakReference<SimulcastManager> wr = this.weakPeerSM;
        SimulcastManager simulcastManager = peerSM = wr != null ? (SimulcastManager)((Object)wr.get()) : null;
        if (peerSM == null) {
            logger.warn((Object)"The peer simulcast manager is null!");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)Arrays.toString(Thread.currentThread().getStackTrace()));
            }
        }
        return peerSM;
    }

    private Endpoint getSelf() {
        VideoChannel vc;
        Endpoint self;
        SimulcastManager sm = this.mySM;
        Endpoint endpoint = self = sm != null && (vc = sm.getVideoChannel()) != null ? vc.getEndpoint() : null;
        if (self == null) {
            logger.warn((Object)"Self is null!");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)Arrays.toString(Thread.currentThread().getStackTrace()));
            }
        }
        return self;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeConfigureNext(SimulcastReceiverOptions options) {
        if (options == null) {
            if (logger.isWarnEnabled()) {
                HashMap<String, Object> map = new HashMap<String, Object>(1);
                map.put("self", this.getSelf());
                StringCompiler sc = new StringCompiler(map);
                logger.warn((Object)sc.c("{self.id} cannot configure next simulcast layer because the parameter is null."));
            }
            return;
        }
        Integer nextOrder = options.getNextOrder();
        if (nextOrder == null) {
            return;
        }
        SimulcastManager peerSM = this.getPeerSM();
        if (peerSM == null || !peerSM.hasLayers()) {
            if (logger.isWarnEnabled()) {
                HashMap<String, Object> map = new HashMap<String, Object>(1);
                map.put("peer", this.getPeer());
                StringCompiler sc = new StringCompiler(map);
                logger.warn((Object)sc.c("{peer.id} doesn't have any simulcast layers."));
            }
            return;
        }
        SimulcastLayer next = peerSM.getSimulcastLayer(options.getNextOrder());
        if (next == null || next.getOrder() != 0 && !next.isStreaming()) {
            if (logger.isDebugEnabled()) {
                HashMap<String, Object> map = new HashMap<String, Object>(1);
                map.put("self", this.getSelf());
                StringCompiler sc = new StringCompiler(map);
                logger.debug((Object)sc.c("{self.id} ignoring request to switch to higher order layer because it is not currently being streamed."));
            }
            return;
        }
        Object object = this.receiveLayersSyncRoot;
        synchronized (object) {
            StringCompiler sc;
            HashMap<String, Object> map;
            SimulcastLayer current = this.getCurrent();
            if (current == next) {
                this.weakNext = null;
                this.seenNext = 0;
                if (logger.isDebugEnabled()) {
                    HashMap<String, Object> map2 = new HashMap<String, Object>(4);
                    map2.put("self", this.getSelf());
                    map2.put("peer", this.getPeer());
                    map2.put("current", current);
                    map2.put("next", next);
                    StringCompiler sc2 = new StringCompiler(map2);
                    logger.debug((Object)sc2.c("The simulcast receiver of {self.id} for {peer.id} already receives layer {next.order} ({next.primarySSRC})."));
                }
                return;
            }
            if (options.isHardSwitch() && next != this.getNext()) {
                if (this.getOverride() == null) {
                    this.askForKeyframe(next);
                } else if (logger.isDebugEnabled()) {
                    map = new HashMap(2);
                    map.put("self", this.getSelf());
                    map.put("peer", this.getPeer());
                    sc = new StringCompiler(map);
                    logger.debug((Object)sc.c("The simulcast receiver of {self.id} for {peer.id} skipped a key frame request because an override is set."));
                }
            }
            if (options.isUrgent() || current == null) {
                if (this.getOverride() == null) {
                    this.sendSimulcastLayersChangedEvent(next);
                } else {
                    map = new HashMap<String, Object>(2);
                    map.put("self", this.getSelf());
                    map.put("peer", this.getPeer());
                    sc = new StringCompiler(map);
                    logger.debug((Object)sc.c("The simulcast receiver of {self.id} for {peer.id} skipped a changed event because an override is set."));
                }
                this.weakCurrent = new WeakReference<SimulcastLayer>(next);
                this.weakNext = null;
                this.seenNext = 0;
                if (logger.isDebugEnabled()) {
                    map = new HashMap(4);
                    map.put("self", this.getSelf());
                    map.put("peer", this.getPeer());
                    map.put("next", next);
                    map.put("urgently", options.isUrgent() ? "urgently" : "");
                    sc = new StringCompiler(map);
                    logger.debug((Object)sc.c("The simulcast receiver of {self.id} for {peer.id} has {urgently} switched to layer {next.order} ({next.primarySSRC}).").toString().replaceAll("\\s+", " "));
                }
            } else {
                if (this.getOverride() == null) {
                    this.sendSimulcastLayersChangingEvent(next);
                } else {
                    map = new HashMap(2);
                    map.put("self", this.getSelf());
                    map.put("peer", this.getPeer());
                    sc = new StringCompiler(map);
                    logger.debug((Object)sc.c("The simulcast receiver of {self.id} for {peer.id} skipped a changing event because an override is set."));
                }
                this.weakNext = new WeakReference<SimulcastLayer>(next);
                this.seenNext = 0;
                if (logger.isDebugEnabled()) {
                    map = new HashMap(3);
                    map.put("self", this.getSelf());
                    map.put("peer", this.getPeer());
                    map.put("next", next);
                    sc = new StringCompiler(map);
                    logger.debug((Object)sc.c("The simulcast receiver of {self.id} for {peer.id} is going to switch to layer {next.order} ({next.primarySSRC}) in a few moments.."));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeConfigureOverride(SimulcastReceiverOptions options) {
        SimulcastLayer override;
        if (options == null) {
            if (logger.isWarnEnabled()) {
                HashMap<String, Object> map = new HashMap<String, Object>(1);
                map.put("self", this.getSelf());
                StringCompiler sc = new StringCompiler(map);
                logger.warn((Object)sc.c("{self.id} cannot configure override simulcast layer because the parameter is null."));
            }
            return;
        }
        Integer overrideOrder = options.getOverrideOrder();
        if (overrideOrder == null) {
            return;
        }
        SimulcastManager peerSM = this.getPeerSM();
        if (peerSM == null || !peerSM.hasLayers()) {
            if (logger.isWarnEnabled()) {
                HashMap<String, Object> map = new HashMap<String, Object>(1);
                map.put("peer", this.getPeer());
                StringCompiler sc = new StringCompiler(map);
                logger.warn((Object)sc.c("{peer.id} doesn't have any simulcast layers."));
            }
            return;
        }
        if (overrideOrder == -1) {
            HashMap<String, Object> map;
            if (logger.isDebugEnabled()) {
                map = new HashMap<String, Object>(2);
                map.put("self", this.getSelf());
                map.put("peer", this.getPeer());
                StringCompiler sc = new StringCompiler(map);
                logger.debug((Object)sc.c("The simulcast receiver of {self.id} for {peer.id} is no longer overriding the receiving layer."));
            }
            map = this.receiveLayersSyncRoot;
            synchronized (map) {
                this.weakOverride = null;
                SimulcastLayer current = this.getCurrent();
                if (current != null) {
                    this.askForKeyframe(current);
                    this.sendSimulcastLayersChangedEvent(current);
                }
            }
        }
        if (peerSM != null && (override = peerSM.getSimulcastLayer(overrideOrder)) != null) {
            if (logger.isDebugEnabled()) {
                HashMap<String, Object> map = new HashMap<String, Object>(3);
                map.put("self", this.getSelf());
                map.put("peer", this.getPeer());
                map.put("override", override);
                StringCompiler sc = new StringCompiler(map);
                logger.debug((Object)sc.c("The simulcast receiver of {self.id} for {peer.id} is now configured to override the receiving layer with the {override.order}-order layer {override.primarySSRC}."));
            }
            Object object = this.receiveLayersSyncRoot;
            synchronized (object) {
                this.weakOverride = new WeakReference<SimulcastLayer>(override);
                this.askForKeyframe(override);
                this.sendSimulcastLayersChangedEvent(override);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeForgetNext() {
        Object object = this.receiveLayersSyncRoot;
        synchronized (object) {
            SimulcastLayer next = this.getNext();
            if (next != null && !next.isStreaming()) {
                this.weakNext = null;
                this.seenNext = 0;
            }
        }
    }

    private boolean maybeReceiveHighFrom(String id) {
        Endpoint peer;
        if (!StringUtils.isNullOrEmpty((String)id) && (peer = this.getPeer()) != null && id.equals(peer.getID())) {
            SimulcastReceiverOptions options = new SimulcastReceiverOptions();
            options.setNextOrder(1);
            options.setHardSwitch(true);
            this.configure(options);
            return true;
        }
        return false;
    }

    private boolean maybeReceiveLowFrom(String id) {
        Endpoint peer;
        if (!StringUtils.isNullOrEmpty((String)id) && (peer = this.getPeer()) != null && id.equals(peer.getID())) {
            SimulcastReceiverOptions options = new SimulcastReceiverOptions();
            options.setNextOrder(0);
            options.setHardSwitch(true);
            this.configure(options);
            return true;
        }
        return false;
    }

    private void maybeSendStartHighQualityStreamCommand(String id) {
        SctpConnection sctpConnection;
        VideoChannel newVideoChannel;
        List<RtpChannel> newVideoChannels;
        Endpoint newEndpoint = null;
        SortedSet<SimulcastLayer> newSimulcastLayers = null;
        if (!StringUtils.isNullOrEmpty((String)id) && id != "SELECTED_ENDPOINT_NOT_WATCHING_VIDEO" && (newEndpoint = this.mySM.getVideoChannel().getContent().getConference().getEndpoint(id)) != null && (newVideoChannels = newEndpoint.getChannels(MediaType.VIDEO)) != null && newVideoChannels.size() != 0 && (newVideoChannel = (VideoChannel)newVideoChannels.get(0)) != null) {
            newSimulcastLayers = newVideoChannel.getSimulcastManager().getSimulcastLayers();
        }
        if (newSimulcastLayers != null && newSimulcastLayers.size() > 1 && (sctpConnection = newEndpoint.getSctpConnection()) != null && sctpConnection.isReady() && !sctpConnection.isExpired()) {
            boolean startHighQualityStream = false;
            for (Endpoint e : this.mySM.getVideoChannel().getContent().getConference().getEndpoints()) {
                if (e == newEndpoint) continue;
                String eSelectedEndpointID = e.getSelectedEndpointID();
                if (!newEndpoint.getID().equals(eSelectedEndpointID)) continue;
                if (logger.isDebugEnabled()) {
                    HashMap<String, Object> map = new HashMap<String, Object>(3);
                    map.put("e", e);
                    map.put("newEndpoint", newEndpoint);
                    map.put("maybe", StringUtils.isNullOrEmpty((String)eSelectedEndpointID) ? "(maybe) " : "");
                    StringCompiler sc = new StringCompiler(map).c("{e.id} is {maybe} watching {newEndpoint.id}.");
                    logger.debug((Object)sc.toString().replaceAll("\\s+", " "));
                }
                startHighQualityStream = true;
                break;
            }
            if (startHighQualityStream) {
                logger.debug((Object)(this.mySM.getVideoChannel().getEndpoint().getID() + " notifies " + newEndpoint.getID() + " to start its HQ stream."));
                SimulcastLayer hqLayer = newSimulcastLayers.last();
                StartSimulcastLayerCommand command = new StartSimulcastLayerCommand(hqLayer);
                String json = mapper.toJson(command);
                try {
                    newEndpoint.sendMessageOnDataChannel(json);
                }
                catch (IOException e) {
                    logger.error((Object)(newEndpoint.getID() + " failed to send message on data channel."), (Throwable)e);
                }
            }
        }
    }

    private void maybeSendStopHighQualityStreamCommand(String id) {
        SctpConnection sctpConnection;
        Endpoint oldEndpoint = null;
        if (!StringUtils.isNullOrEmpty((String)id) && id != "SELECTED_ENDPOINT_NOT_WATCHING_VIDEO") {
            oldEndpoint = this.mySM.getVideoChannel().getContent().getConference().getEndpoint(id);
        }
        List<RtpChannel> oldVideoChannels = null;
        if (oldEndpoint != null) {
            oldVideoChannels = oldEndpoint.getChannels(MediaType.VIDEO);
        }
        VideoChannel oldVideoChannel = null;
        if (oldVideoChannels != null && oldVideoChannels.size() != 0) {
            oldVideoChannel = (VideoChannel)oldVideoChannels.get(0);
        }
        SortedSet<SimulcastLayer> oldSimulcastLayers = null;
        if (oldVideoChannel != null) {
            oldSimulcastLayers = oldVideoChannel.getSimulcastManager().getSimulcastLayers();
        }
        if (oldSimulcastLayers != null && oldSimulcastLayers.size() > 1 && (sctpConnection = oldEndpoint.getSctpConnection()) != null && sctpConnection.isReady() && !sctpConnection.isExpired()) {
            boolean stopHighQualityStream = true;
            for (Endpoint e : this.mySM.getVideoChannel().getContent().getConference().getEndpoints()) {
                if (oldEndpoint == e || !oldEndpoint.getID().equals(e.getSelectedEndpointID()) && !StringUtils.isNullOrEmpty((String)e.getSelectedEndpointID())) continue;
                stopHighQualityStream = false;
                break;
            }
            if (stopHighQualityStream) {
                logger.debug((Object)(this.mySM.getVideoChannel().getEndpoint().getID() + " notifies " + oldEndpoint.getID() + " to stop " + "its HQ stream."));
                SimulcastLayer hqLayer = oldSimulcastLayers.last();
                StopSimulcastLayerCommand command = new StopSimulcastLayerCommand(hqLayer);
                String json = mapper.toJson(command);
                try {
                    oldEndpoint.sendMessageOnDataChannel(json);
                }
                catch (IOException e1) {
                    logger.error((Object)(oldEndpoint.getID() + " failed to send " + "message on data channel."), (Throwable)e1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeSwitchToNext() {
        Object object = this.receiveLayersSyncRoot;
        synchronized (object) {
            SimulcastLayer next = this.getNext();
            if (next != null) {
                ++this.seenNext;
                if ((double)this.seenNext > 125.0 * Math.pow(2.0, next.getOrder())) {
                    StringCompiler sc;
                    HashMap<String, Object> map;
                    if (this.getOverride() == null) {
                        this.sendSimulcastLayersChangedEvent(next);
                    } else if (logger.isDebugEnabled()) {
                        map = new HashMap<String, Object>(2);
                        map.put("self", this.getSelf());
                        map.put("peer", this.getPeer());
                        sc = new StringCompiler(map);
                        logger.debug((Object)sc.c("The simulcast receiver of {self.id} for {peer.id} skipped a changed event because an override is set."));
                    }
                    this.weakCurrent = this.weakNext;
                    this.weakNext = null;
                    if (logger.isDebugEnabled()) {
                        map = new HashMap(3);
                        map.put("self", this.getSelf());
                        map.put("peer", this.getPeer());
                        map.put("next", next);
                        sc = new StringCompiler(map);
                        logger.debug((Object)sc.c("The simulcast receiver of {self.id} for {peer.id} has now switched to the next layer of order {next.order} ({next.primarySSRC})."));
                    }
                }
            }
        }
    }

    private void onEndpointChanged(Endpoint newValue, Endpoint oldValue) {
        if (newValue != null) {
            newValue.addPropertyChangeListener(this.weakPropertyChangeListener);
        } else {
            logger.warn((Object)"Cannot listen on self, it's null!");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)Arrays.toString(Thread.currentThread().getStackTrace()));
            }
        }
        if (oldValue != null) {
            oldValue.removePropertyChangeListener(this.weakPropertyChangeListener);
        }
    }

    private void onPeerLayerChanged(SimulcastLayer layer) {
        if (!layer.isStreaming()) {
            SimulcastReceiverOptions options = new SimulcastReceiverOptions();
            options.setNextOrder(0);
            options.setHardSwitch(true);
            options.setUrgent(true);
            this.configure(options);
            this.maybeForgetNext();
        } else {
            Endpoint self = this.getSelf();
            Endpoint peer = this.getPeer();
            if (peer != null && self != null && peer.getID().equals(self.getSelectedEndpointID())) {
                SimulcastReceiverOptions options = new SimulcastReceiverOptions();
                options.setNextOrder(1);
                this.configure(options);
            }
        }
    }

    private void onPeerLayersChanged(SimulcastManager peerSM) {
        if (peerSM != null && peerSM.hasLayers()) {
            for (SimulcastLayer layer : peerSM.getSimulcastLayers()) {
                layer.addPropertyChangeListener(this.weakPropertyChangeListener);
            }
            this.configure(initOptions);
            if (logger.isDebugEnabled()) {
                HashMap<String, Object> map = new HashMap<String, Object>(2);
                map.put("self", this.getSelf());
                map.put("peer", this.getPeer());
                StringCompiler sc = new StringCompiler(map);
                logger.debug((Object)sc.c("{self.id} listens on layer changes from {peer.id}."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSelectedEndpointChanged(String oldValue, String newValue) {
        Object object = this.receiveLayersSyncRoot;
        synchronized (object) {
            if (this.maybeReceiveHighFrom(newValue)) {
                this.maybeSendStartHighQualityStreamCommand(newValue);
            }
            if (this.maybeReceiveLowFrom(oldValue)) {
                this.maybeSendStopHighQualityStreamCommand(oldValue);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SimulcastLayer.IS_STREAMING_PROPERTY.equals(propertyChangeEvent.getPropertyName())) {
            SimulcastLayer layer = (SimulcastLayer)propertyChangeEvent.getSource();
            this.onPeerLayerChanged(layer);
        } else if (Endpoint.SELECTED_ENDPOINT_PROPERTY_NAME.equals(propertyChangeEvent.getPropertyName())) {
            String oldValue = (String)propertyChangeEvent.getOldValue();
            String newValue = (String)propertyChangeEvent.getNewValue();
            this.onSelectedEndpointChanged(oldValue, newValue);
        } else if (".endpoint".equals(propertyChangeEvent.getPropertyName())) {
            Endpoint newValue = (Endpoint)propertyChangeEvent.getNewValue();
            Endpoint oldValue = (Endpoint)propertyChangeEvent.getOldValue();
            this.onEndpointChanged(newValue, oldValue);
        } else if (SimulcastManager.SIMULCAST_LAYERS_PROPERTY.equals(propertyChangeEvent.getPropertyName())) {
            SimulcastManager peerSM = (SimulcastManager)((Object)propertyChangeEvent.getSource());
            this.onPeerLayersChanged(peerSM);
        }
    }

    private void sendSimulcastLayersChangedEvent(SimulcastLayer layer) {
        Endpoint peer;
        if (layer == null) {
            logger.warn((Object)"Requested to send a simulcast layers changed eventbut layer is null!");
            return;
        }
        Endpoint self = this.getSelf();
        if (self != null && (peer = this.getPeer()) != null) {
            logger.debug((Object)("Sending a simulcast layers changed event to " + self.getID() + "."));
            SimulcastLayersChangedEvent ev = new SimulcastLayersChangedEvent();
            ev.endpointSimulcastLayers = new EndpointSimulcastLayer[]{new EndpointSimulcastLayer(peer.getID(), layer)};
            String json = mapper.toJson(ev);
            try {
                self.sendMessageOnDataChannel(json);
            }
            catch (IOException e) {
                logger.error((Object)(self.getID() + " failed to send message on " + "data channel."), (Throwable)e);
            }
        } else {
            logger.warn((Object)"Didn't send simulcast layers changed event because self == null || peer == null || current == null");
        }
    }

    private void sendSimulcastLayersChangingEvent(SimulcastLayer layer) {
        Endpoint peer;
        if (layer == null) {
            logger.warn((Object)"Requested to send a simulcast layers changing eventbut layer is null!");
            return;
        }
        Endpoint self = this.getSelf();
        if (self != null && (peer = this.getPeer()) != null) {
            logger.debug((Object)("Sending a simulcast layers changing event to " + self.getID() + "."));
            SimulcastLayersChangingEvent ev = new SimulcastLayersChangingEvent();
            ev.endpointSimulcastLayers = new EndpointSimulcastLayer[]{new EndpointSimulcastLayer(peer.getID(), layer)};
            String json = mapper.toJson(ev);
            try {
                self.sendMessageOnDataChannel(json);
            }
            catch (IOException e) {
                logger.error((Object)(self.getID() + " failed to send message on " + "data channel."), (Throwable)e);
            }
        } else {
            logger.warn((Object)"Didn't send simulcast layers changing event because self == null || peer == null || current == null");
        }
    }

    static {
        logger = Logger.getLogger(SimulcastReceiver.class);
        mapper = new SimulcastMessagesMapper();
        initOptions = new SimulcastReceiverOptions();
        initOptions.setNextOrder(0);
    }
}

