/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.impl.protocol.jabber.JabberActivator;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.service.credentialsstorage.CredentialsStorageService;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.StunServerDescriptor;
import net.java.sip.communicator.service.protocol.jabber.JabberAccountID;
import org.osgi.framework.BundleContext;

public class JabberAccountIDImpl
extends JabberAccountID {
    JabberAccountIDImpl(String id, Map<String, String> accountProperties) {
        super(id, accountProperties);
    }

    public List<StunServerDescriptor> getStunServers() {
        StunServerDescriptor stunServer;
        Map accountProperties = this.getAccountProperties();
        ArrayList<StunServerDescriptor> serList = new ArrayList<StunServerDescriptor>();
        for (int i = 0; i < 100 && (stunServer = StunServerDescriptor.loadDescriptor((Map)accountProperties, (String)("STUN" + i))) != null; ++i) {
            String password = this.loadStunPassword("STUN" + i);
            if (password != null) {
                stunServer.setPassword(password);
            }
            serList.add(stunServer);
        }
        return serList;
    }

    private String loadStunPassword(String namePrefix) {
        String password = null;
        String className = ProtocolProviderServiceJabberImpl.class.getName();
        String packageSourceName = className.substring(0, className.lastIndexOf(46));
        String accountPrefix = ProtocolProviderFactory.findAccountPrefix((BundleContext)JabberActivator.bundleContext, (AccountID)this, (String)packageSourceName);
        CredentialsStorageService credentialsService = JabberActivator.getCredentialsStorageService();
        try {
            password = credentialsService.loadPassword(accountPrefix + "." + namePrefix);
        }
        catch (Exception e) {
            return null;
        }
        return password;
    }
}

