/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tools.ant.Task;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ConcatFileInputStream
extends InputStream {
    private static final int EOF = -1;
    private int currentIndex;
    private boolean eof;
    private File[] file;
    private InputStream currentStream;
    private Task managingTask;

    public void close() throws IOException {
        this.closeCurrent();
        this.eof = true;
    }

    public int read() throws IOException {
        int n = this.readCurrent();
        if (n == -1 && !this.eof) {
            this.openFile(++this.currentIndex);
            n = this.readCurrent();
        }
        return n;
    }

    public void setManagingTask(Task task) {
        this.managingTask = task;
    }

    public void log(String string, int n) {
        if (this.managingTask != null) {
            this.managingTask.log(string, n);
        } else if (n > 1) {
            System.out.println(string);
        } else {
            System.err.println(string);
        }
    }

    private final int readCurrent() throws IOException {
        return this.eof || this.currentStream == null ? -1 : this.currentStream.read();
    }

    private final void openFile(int n) throws IOException {
        this.closeCurrent();
        if (this.file != null && n < this.file.length) {
            this.log("Opening " + this.file[n], 3);
            this.currentStream = new BufferedInputStream(new FileInputStream(this.file[n]));
        } else {
            this.eof = true;
        }
    }

    private final void closeCurrent() {
        if (this.currentStream != null) {
            try {
                this.currentStream.close();
            }
            catch (IOException iOException) {}
            this.currentStream = null;
        }
    }

    private final /* synthetic */ void this() {
        this.currentIndex = 0;
        this.eof = false;
    }

    public ConcatFileInputStream(File[] fileArray) throws IOException {
        this.this();
        this.file = fileArray;
        this.openFile(this.currentIndex);
    }
}

