/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd.sendfile;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;

public class FileSendBlock
implements LiveWritable {
    public static final int SENDTYPE_SINGLEFILE = 1;
    public static final int SENDTYPE_DIR = 2;
    private final int sendType;
    private final int fileCount;
    private final long totalFileSize;
    private final String filename;

    public static FileSendBlock readFileSendBlock(ByteBlock block) {
        int firstNull;
        DefensiveTools.checkNull((Object)block, (String)"block");
        int type = BinaryTools.getUShort((ByteBlock)block, (int)0);
        int count = BinaryTools.getUShort((ByteBlock)block, (int)2);
        long size = BinaryTools.getUInt((ByteBlock)block, (int)4);
        ByteBlock filenameBlock = block.subBlock(8);
        for (firstNull = 0; firstNull < filenameBlock.getLength() && filenameBlock.get(firstNull) != 0; ++firstNull) {
        }
        String name = null;
        name = BinaryTools.getUtf8String((ByteBlock)filenameBlock.subBlock(0, firstNull));
        return new FileSendBlock(type, name, count, size);
    }

    public FileSendBlock(String filename, long size) {
        this(1, filename, 1, size);
    }

    public FileSendBlock(int sendType, String filename, int fileCount, long totalFileSize) {
        DefensiveTools.checkRange((int)sendType, (String)"sendType", (int)0);
        DefensiveTools.checkRange((int)fileCount, (String)"fileCount", (int)0);
        DefensiveTools.checkRange((long)totalFileSize, (String)"totalFileSize", (long)0L);
        DefensiveTools.checkNull((Object)filename, (String)"filename");
        this.sendType = sendType;
        this.fileCount = fileCount;
        this.totalFileSize = totalFileSize;
        this.filename = filename;
    }

    public final int getSendType() {
        return this.sendType;
    }

    public final int getFileCount() {
        return this.fileCount;
    }

    public final long getTotalFileSize() {
        return this.totalFileSize;
    }

    public final String getFilename() {
        return this.filename;
    }

    public void write(OutputStream out) throws IOException {
        BinaryTools.writeUShort((OutputStream)out, (int)this.sendType);
        BinaryTools.writeUShort((OutputStream)out, (int)this.fileCount);
        BinaryTools.writeUInt((OutputStream)out, (long)this.totalFileSize);
        byte[] bytes = BinaryTools.getUtf8Bytes((String)this.filename);
        if (Arrays.binarySearch(bytes, (byte)0) >= 0) {
            bytes = BinaryTools.getLatinBytes((String)this.filename);
        }
        out.write(bytes);
        out.write(new byte[46]);
    }

    public String toString() {
        return "FileSendBlock: type=" + this.sendType + (this.fileCount > 1 ? ", " + this.fileCount + " files under " + this.filename : ": " + this.filename) + ": " + this.totalFileSize + " bytes total";
    }
}

