/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.util;

import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.MediaLocator;
import javax.media.NoPlayerException;
import javax.swing.JApplet;
import javax.swing.JFrame;
import net.sf.fmj.ejmf.toolkit.util.PlayerPanel;
import net.sf.fmj.ejmf.toolkit.util.Utility;
import net.sf.fmj.utility.FmjStartup;
import net.sf.fmj.utility.LoggerSingleton;

public abstract class PlayerDriver
extends JApplet {
    private static final Logger logger = LoggerSingleton.logger;
    private JFrame frame;
    private PlayerPanel playerpanel;

    public static void main(PlayerDriver playerDriver, String[] stringArray) {
        if (stringArray.length == 0) {
            logger.severe("Media parameter not specified");
            return;
        }
        MediaLocator mediaLocator = Utility.appArgToMediaLocator(stringArray[0]);
        try {
            playerDriver.initialize(mediaLocator);
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "Could not connect to media: " + iOException, iOException);
            System.exit(1);
        }
        catch (NoPlayerException noPlayerException) {
            logger.log(Level.WARNING, "Player not found for media: " + noPlayerException, noPlayerException);
            System.exit(1);
        }
    }

    public PlayerDriver() {
        this.getRootPane().putClientProperty("defeatSystemEventQueueCheck", Boolean.TRUE);
    }

    public abstract void begin();

    public void destroy() {
        super.destroy();
        if (this.getPlayerPanel() != null && this.getPlayerPanel().getPlayer() != null) {
            this.getPlayerPanel().getPlayer().stop();
            this.getPlayerPanel().getPlayer().close();
        }
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public PlayerPanel getPlayerPanel() {
        return this.playerpanel;
    }

    public void init() {
        FmjStartup.initApplet();
        String string = this.getParameter("MEDIA");
        if (string == null) {
            logger.warning("Error: MEDIA parameter not specified");
            return;
        }
        MediaLocator mediaLocator = Utility.appletArgToMediaLocator(this, string);
        try {
            this.playerpanel = new PlayerPanel(mediaLocator);
            this.playerpanel.getMediaPanel().addContainerListener(new ContainerListener(){

                public void componentAdded(ContainerEvent containerEvent) {
                    PlayerDriver.this.pack();
                }

                public void componentRemoved(ContainerEvent containerEvent) {
                    PlayerDriver.this.pack();
                }
            });
            this.getContentPane().add(this.playerpanel);
            this.pack();
            this.begin();
        }
        catch (IOException iOException) {
            logger.warning("Could not connect to media");
            this.destroy();
        }
        catch (NoPlayerException noPlayerException) {
            logger.warning("Player not found for media");
            this.destroy();
        }
    }

    public void initialize(MediaLocator mediaLocator) throws IOException, NoPlayerException {
        this.playerpanel = new PlayerPanel(mediaLocator);
        this.frame = new JFrame(mediaLocator.toString());
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.playerpanel.getMediaPanel().addContainerListener(new ContainerListener(){

            public void componentAdded(ContainerEvent containerEvent) {
                PlayerDriver.this.frame.pack();
            }

            public void componentRemoved(ContainerEvent containerEvent) {
                PlayerDriver.this.frame.pack();
            }
        });
        Container container = this.frame.getContentPane();
        container.add(this.playerpanel);
        this.frame.pack();
        this.frame.setVisible(true);
        this.begin();
    }

    public void pack() {
        this.setSize(this.getPreferredSize());
        this.validate();
    }

    public void redraw() {
        this.frame.pack();
    }
}

