/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pl.mn.communicator.AbstractMessage;
import pl.mn.communicator.IOutgoingMessage;
import pl.mn.communicator.MessageClass;

public class OutgoingMessage
extends AbstractMessage
implements IOutgoingMessage {
    private static final Random RANDOM = new Random();
    private static final Log LOGGER = LogFactory.getLog((Class)OutgoingMessage.class);
    private ArrayList m_additionalRecipients = new ArrayList();

    private OutgoingMessage(int uin, String text, MessageClass messageClass) {
        super(uin, text, messageClass);
        this.m_messageID = RANDOM.nextInt(99999);
    }

    public static OutgoingMessage createNewMessage(int uin, String messageBody) {
        return new OutgoingMessage(uin, messageBody, MessageClass.MESSAGE);
    }

    public static OutgoingMessage createChatMessage(int uin, String messageBody) {
        return new OutgoingMessage(uin, messageBody, MessageClass.CHAT);
    }

    public static OutgoingMessage createPingMessage(int uin) {
        return new OutgoingMessage(uin, "", MessageClass.PING);
    }

    public static OutgoingMessage createMessageWithoutConfirmation(int uin, String messageBody) {
        return new OutgoingMessage(uin, messageBody, MessageClass.DO_NOT_CONFIRM);
    }

    public void setMessageBody(String messageBody) {
        if (messageBody == null) {
            throw new NullPointerException("messageBody cannot be null");
        }
        this.m_messageBody = messageBody;
    }

    public void setRecipientUin(int recipientUin) {
        if (recipientUin < 0) {
            throw new IllegalArgumentException("uin cannot be less than 0");
        }
        this.m_recipientUin = recipientUin;
    }

    public void addAdditionalRecipient(int recipientUin) {
        if (recipientUin < 0) {
            throw new IllegalArgumentException("uin cannot be less than 0");
        }
        this.m_additionalRecipients.add(new Integer(recipientUin));
    }

    public void removeAdditionalRecipient(int recipientUin) {
        if (recipientUin < 0) {
            throw new IllegalArgumentException("uin cannot be less than 0");
        }
        this.m_additionalRecipients.remove(new Integer(recipientUin));
    }

    public int[] getAdditionalRecipients() {
        int[] additionalRecipients = new int[this.m_additionalRecipients.size()];
        int i = 0;
        Iterator it = this.m_additionalRecipients.iterator();
        while (it.hasNext()) {
            additionalRecipients[i++] = (Integer)it.next();
        }
        return additionalRecipients;
    }

    public int[] getAllRecipients() {
        int[] allRecipients = new int[this.m_additionalRecipients.size() + 1];
        allRecipients[0] = this.m_recipientUin;
        int i = 1;
        Iterator it = this.m_additionalRecipients.iterator();
        while (it.hasNext()) {
            allRecipients[i++] = (Integer)it.next();
        }
        return allRecipients;
    }
}

