/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.ice.Agent;
import org.ice4j.ice.CandidatePair;
import org.ice4j.ice.Component;
import org.ice4j.ice.IceMediaStream;
import org.ice4j.ice.IceProcessingState;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.NominationStrategy;
import org.ice4j.ice.RemoteCandidate;
import org.ice4j.ice.harvest.StunCandidateHarvester;
import org.ice4j.ice.harvest.TurnCandidateHarvester;
import org.ice4j.pseudotcp.PseudoTcpSocket;
import org.ice4j.pseudotcp.PseudoTcpSocketFactory;
import org.ice4j.security.LongTermCredential;
import test.Ice;

public class IcePseudoTcp {
    private static final Logger logger = Logger.getLogger(IcePseudoTcp.class.getName());
    private static long startTime;
    private static LocalPseudoTcpJob localJob;
    private static RemotePseudoTcpJob remoteJob;
    private static final int TEST_BYTES_COUNT = 15000000;
    private static final boolean USE_STUN = true;
    private static final boolean USE_TURN = true;
    private static final Object remoteAgentMonitor;
    private static final Object localAgentMonitor;
    private static long agentJobTimeout;

    protected static Agent createAgent(int pTcpPort) throws Throwable {
        Agent agent = new Agent();
        StunCandidateHarvester stunHarv = new StunCandidateHarvester(new TransportAddress("sip-communicator.net", 3478, Transport.UDP));
        StunCandidateHarvester stun6Harv = new StunCandidateHarvester(new TransportAddress("ipv6.sip-communicator.net", 3478, Transport.UDP));
        agent.addCandidateHarvester(stunHarv);
        agent.addCandidateHarvester(stun6Harv);
        String[] hostnames = new String[]{"130.79.90.150", "2001:660:4701:1001:230:5ff:fe1a:805f"};
        int port = 3478;
        LongTermCredential longTermCredential = new LongTermCredential("guest", "anonymouspower!!");
        for (String hostname : hostnames) {
            agent.addCandidateHarvester(new TurnCandidateHarvester(new TransportAddress(hostname, port, Transport.UDP), longTermCredential));
        }
        IcePseudoTcp.createStream(pTcpPort, "data", agent);
        return agent;
    }

    private static IceMediaStream createStream(int pTcpPort, String streamName, Agent agent) throws Throwable {
        IceMediaStream stream = agent.createMediaStream(streamName);
        long startTime = System.currentTimeMillis();
        agent.createComponent(stream, Transport.UDP, pTcpPort, pTcpPort, pTcpPort + 100);
        long endTime = System.currentTimeMillis();
        logger.log(Level.INFO, "UDP Component created in " + (endTime - startTime) + " ms");
        startTime = endTime;
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Throwable {
        startTime = System.currentTimeMillis();
        int localPort = 7999;
        int remotePort = 6000;
        Agent localAgent = IcePseudoTcp.createAgent(localPort);
        localAgent.setNominationStrategy(NominationStrategy.NOMINATE_HIGHEST_PRIO);
        Agent remotePeer = IcePseudoTcp.createAgent(remotePort);
        localAgent.addStateChangeListener(new LocalIceProcessingListener());
        remotePeer.addStateChangeListener(new RemoteIceProcessingListener());
        localAgent.setControlling(true);
        remotePeer.setControlling(false);
        long endTime = System.currentTimeMillis();
        Ice.transferRemoteCandidates(localAgent, remotePeer);
        for (IceMediaStream stream : localAgent.getStreams()) {
            stream.setRemoteUfrag(remotePeer.getLocalUfrag());
            stream.setRemotePassword(remotePeer.getLocalPassword());
        }
        Ice.transferRemoteCandidates(remotePeer, localAgent);
        for (IceMediaStream stream : remotePeer.getStreams()) {
            stream.setRemoteUfrag(localAgent.getLocalUfrag());
            stream.setRemotePassword(localAgent.getLocalPassword());
        }
        logger.log(Level.INFO, "Total candidate gathering time: {0} ms", endTime - startTime);
        logger.log(Level.INFO, "LocalAgent: {0}", localAgent);
        localAgent.startConnectivityEstablishment();
        remotePeer.startConnectivityEstablishment();
        IceMediaStream dataStream = localAgent.getStream("data");
        if (dataStream != null) {
            logger.log(Level.INFO, "Local data clist:" + dataStream.getCheckList());
        }
        Object object = remoteAgentMonitor;
        synchronized (object) {
            remoteAgentMonitor.wait(agentJobTimeout);
        }
        if (remoteJob != null) {
            logger.log(Level.FINEST, "Remote thread join started");
            remoteJob.join();
            logger.log(Level.FINEST, "Remote thread joined");
        }
        remotePeer.free();
        if (localJob != null) {
            logger.log(Level.FINEST, "Local thread join started");
            localJob.join();
            logger.log(Level.FINEST, "Local thread joined");
        }
        localAgent.free();
        System.exit(0);
    }

    static {
        localJob = null;
        remoteJob = null;
        remoteAgentMonitor = new Object();
        localAgentMonitor = new Object();
        agentJobTimeout = 15000L;
    }

    private static class RemotePseudoTcpJob
    extends Thread
    implements Runnable {
        private DatagramSocket dgramSocket;
        private InetSocketAddress peerAddr;

        public RemotePseudoTcpJob(DatagramSocket socket, InetSocketAddress peerAddr) throws UnknownHostException {
            this.dgramSocket = socket;
            this.peerAddr = peerAddr;
        }

        public void run() {
            logger.log(Level.FINEST, "Remote pseudotcp worker started");
            try {
                logger.log(Level.INFO, "Remote pseudotcp is using: " + this.dgramSocket.getLocalSocketAddress() + " and will comunicate with: " + this.peerAddr);
                PseudoTcpSocket socket = new PseudoTcpSocketFactory().createSocket(this.dgramSocket);
                socket.setConversationID(0x40000000L);
                socket.setMTU(1500);
                socket.setDebugName("R");
                long start = System.currentTimeMillis();
                socket.connect(this.peerAddr, 5000);
                byte[] buffer = new byte[15000000];
                socket.getOutputStream().write(buffer);
                socket.getOutputStream().flush();
                long end = System.currentTimeMillis();
                logger.log(Level.INFO, "Transferred 15000000 bytes in " + (end - start) / 1000L + " sec");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            logger.log(Level.FINEST, "Remote pseudotcp worker finished");
        }
    }

    private static class LocalPseudoTcpJob
    extends Thread
    implements Runnable {
        private DatagramSocket dgramSocket;

        public LocalPseudoTcpJob(DatagramSocket socket) throws UnknownHostException {
            this.dgramSocket = socket;
        }

        public void run() {
            logger.log(Level.FINEST, "Local pseudotcp worker started");
            try {
                logger.log(Level.INFO, "Local pseudotcp is using: " + this.dgramSocket.getLocalSocketAddress() + this.dgramSocket);
                PseudoTcpSocket socket = new PseudoTcpSocketFactory().createSocket(this.dgramSocket);
                socket.setConversationID(0x40000000L);
                socket.setMTU(1500);
                socket.setDebugName("L");
                socket.accept(5000);
                byte[] buffer = new byte[15000000];
                int read = 0;
                while (read != 15000000) {
                    logger.log(Level.FINEST, "Local job read: " + (read += socket.getInputStream().read(buffer)));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            logger.log(Level.FINEST, "Local pseudotcp worker finished");
        }
    }

    private static final class RemoteIceProcessingListener
    implements PropertyChangeListener {
        private RemoteIceProcessingListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            long processingEndTime = System.currentTimeMillis();
            Object iceProcessingState = evt.getNewValue();
            logger.log(Level.INFO, "Remote agent entered the " + iceProcessingState + " state.");
            if (iceProcessingState == IceProcessingState.COMPLETED) {
                logger.log(Level.INFO, "Remote: Total ICE processing time: " + (processingEndTime - startTime) + " ms ");
                Agent agent = (Agent)evt.getSource();
                logger.log(Level.INFO, "Remote: Create pseudo tcp stream");
                IceMediaStream dataStream = agent.getStream("data");
                Component udpComponent = dataStream.getComponents().get(0);
                CandidatePair usedPair = udpComponent.getSelectedPair();
                if (usedPair != null) {
                    LocalCandidate localCandidate = usedPair.getLocalCandidate();
                    RemoteCandidate remoteCandidate = usedPair.getRemoteCandidate();
                    logger.log(Level.INFO, "Remote: Local address " + localCandidate);
                    logger.log(Level.INFO, "Remote: Peer address " + remoteCandidate);
                    try {
                        remoteJob = new RemotePseudoTcpJob(localCandidate.getDatagramSocket(), remoteCandidate.getTransportAddress());
                    }
                    catch (UnknownHostException ex) {
                        logger.log(Level.SEVERE, "Error while trying to create remote pseudotcp thread " + ex);
                    }
                } else {
                    logger.log(Level.SEVERE, "Remote: Failed to select any candidate pair");
                }
            } else if (iceProcessingState == IceProcessingState.TERMINATED || iceProcessingState == IceProcessingState.FAILED) {
                if (remoteJob != null && iceProcessingState == IceProcessingState.TERMINATED) {
                    remoteJob.start();
                }
                Object object = remoteAgentMonitor;
                synchronized (object) {
                    remoteAgentMonitor.notifyAll();
                }
            }
        }
    }

    private static final class LocalIceProcessingListener
    implements PropertyChangeListener {
        private LocalIceProcessingListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            long processingEndTime = System.currentTimeMillis();
            Object iceProcessingState = evt.getNewValue();
            logger.log(Level.INFO, "Local agent entered the " + iceProcessingState + " state.");
            if (iceProcessingState == IceProcessingState.COMPLETED) {
                logger.log(Level.INFO, "Local - Total ICE processing time: " + (processingEndTime - startTime) + "ms");
                Agent agent = (Agent)evt.getSource();
                logger.log(Level.INFO, "Local: Create pseudo tcp stream");
                IceMediaStream dataStream = agent.getStream("data");
                Component udpComponent = dataStream.getComponents().get(0);
                CandidatePair selectedPair = udpComponent.getSelectedPair();
                if (selectedPair != null) {
                    LocalCandidate localCandidate = selectedPair.getLocalCandidate();
                    RemoteCandidate remoteCandidate = selectedPair.getRemoteCandidate();
                    logger.log(Level.INFO, "Local: " + localCandidate);
                    logger.log(Level.INFO, "Remote: " + remoteCandidate);
                    try {
                        localJob = new LocalPseudoTcpJob(localCandidate.getDatagramSocket());
                    }
                    catch (UnknownHostException ex) {
                        logger.log(Level.SEVERE, "Error while trying to create local pseudotcp thread " + ex);
                    }
                } else {
                    logger.log(Level.INFO, "Failed to select any candidate pair");
                }
            } else if (iceProcessingState == IceProcessingState.TERMINATED || iceProcessingState == IceProcessingState.FAILED) {
                if (localJob != null && iceProcessingState == IceProcessingState.TERMINATED) {
                    localJob.start();
                }
                Object object = localAgentMonitor;
                synchronized (object) {
                    localAgentMonitor.notifyAll();
                }
            }
        }
    }
}

