/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.conference;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.media.Buffer;
import javax.media.CaptureDeviceInfo;
import javax.media.Controls;
import javax.media.Format;
import javax.media.Time;
import javax.media.control.BufferControl;
import javax.media.control.FormatControl;
import javax.media.format.AudioFormat;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullBufferDataSource;
import javax.media.protocol.PullBufferStream;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.PushBufferStream;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceStream;
import org.jitsi.impl.neomedia.MediaStreamImpl;
import org.jitsi.impl.neomedia.conference.AudioMixerPushBufferStream;
import org.jitsi.impl.neomedia.conference.AudioMixingPushBufferDataSource;
import org.jitsi.impl.neomedia.conference.DataSourceFilter;
import org.jitsi.impl.neomedia.conference.InDataSourceDesc;
import org.jitsi.impl.neomedia.conference.InStreamDesc;
import org.jitsi.impl.neomedia.control.ReadOnlyBufferControlDelegate;
import org.jitsi.impl.neomedia.control.ReadOnlyFormatControlDelegate;
import org.jitsi.impl.neomedia.device.MediaDeviceImpl;
import org.jitsi.impl.neomedia.device.ReceiveStreamPushBufferDataSource;
import org.jitsi.impl.neomedia.protocol.BufferStreamAdapter;
import org.jitsi.impl.neomedia.protocol.CachingPushBufferStream;
import org.jitsi.impl.neomedia.protocol.PullBufferStreamAdapter;
import org.jitsi.impl.neomedia.protocol.PushBufferDataSourceAdapter;
import org.jitsi.impl.neomedia.protocol.PushBufferStreamAdapter;
import org.jitsi.impl.neomedia.protocol.TranscodingDataSource;
import org.jitsi.util.Logger;
import org.jitsi.util.OSUtils;

public class AudioMixer {
    private static final AudioFormat DEFAULT_OUTPUT_FORMAT = new AudioFormat("LINEAR", 8000.0, 16, 1, 0, 1);
    private static final Logger logger = Logger.getLogger(AudioMixer.class);
    private BufferControl bufferControl;
    protected final CaptureDevice captureDevice;
    private int connected;
    private final List<InDataSourceDesc> inDataSources = new ArrayList<InDataSourceDesc>();
    private final AudioMixingPushBufferDataSource localOutDataSource;
    private AudioMixerPushBufferStream outStream;
    private int started;
    private long startedGeneration;

    private static Format getFormat(DataSource dataSource) {
        FormatControl formatControl = (FormatControl)dataSource.getControl(FormatControl.class.getName());
        return formatControl == null ? null : formatControl.getFormat();
    }

    private static Format getFormat(SourceStream stream) {
        if (stream instanceof PushBufferStream) {
            return ((PushBufferStream)stream).getFormat();
        }
        if (stream instanceof PullBufferStream) {
            return ((PullBufferStream)stream).getFormat();
        }
        return null;
    }

    public AudioMixer(CaptureDevice captureDevice) {
        if (captureDevice instanceof PullBufferDataSource) {
            captureDevice = new PushBufferDataSourceAdapter((PullBufferDataSource)((Object)captureDevice));
        }
        if (logger.isTraceEnabled()) {
            captureDevice = MediaDeviceImpl.createTracingCaptureDevice(captureDevice, logger);
        }
        this.captureDevice = captureDevice;
        this.localOutDataSource = this.createOutDataSource();
        this.addInDataSource((DataSource)((Object)this.captureDevice), this.localOutDataSource);
    }

    public void addInDataSource(DataSource inDataSource) {
        this.addInDataSource(inDataSource, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addInDataSource(DataSource inDataSource, AudioMixingPushBufferDataSource outDataSource) {
        if (inDataSource == null) {
            throw new NullPointerException("inDataSource");
        }
        List<InDataSourceDesc> list = this.inDataSources;
        synchronized (list) {
            for (InDataSourceDesc inDataSourceDesc : this.inDataSources) {
                if (!inDataSource.equals(inDataSourceDesc.inDataSource)) continue;
                throw new IllegalArgumentException("inDataSource");
            }
            InDataSourceDesc inDataSourceDesc = new InDataSourceDesc(inDataSource, outDataSource);
            boolean added = this.inDataSources.add(inDataSourceDesc);
            if (added) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Added input DataSource with hashCode " + inDataSource.hashCode());
                }
                if (this.connected > 0) {
                    try {
                        inDataSourceDesc.connect(this);
                    }
                    catch (IOException ioex) {
                        throw new UndeclaredThrowableException(ioex);
                    }
                }
                if (this.outStream != null) {
                    this.getOutStream();
                }
                if (this.started > 0) {
                    try {
                        inDataSourceDesc.start();
                    }
                    catch (IOException ioe) {
                        throw new UndeclaredThrowableException(ioe);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connect() throws IOException {
        List<InDataSourceDesc> list = this.inDataSources;
        synchronized (list) {
            if (this.connected == 0) {
                for (InDataSourceDesc inDataSourceDesc : this.inDataSources) {
                    try {
                        inDataSourceDesc.connect(this);
                    }
                    catch (IOException ioe) {
                        logger.error("Failed to connect to inDataSource " + MediaStreamImpl.toString(inDataSourceDesc.inDataSource), ioe);
                        throw ioe;
                    }
                }
                if (this.outStream != null) {
                    this.outStream.equalizeInStreamBufferLength();
                }
            }
            ++this.connected;
        }
    }

    protected void connect(DataSource dataSource, DataSource inDataSource) throws IOException {
        dataSource.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connected(InDataSourceDesc inDataSource) throws IOException {
        List<InDataSourceDesc> list = this.inDataSources;
        synchronized (list) {
            if (this.inDataSources.contains(inDataSource) && this.connected > 0) {
                if (this.started > 0) {
                    inDataSource.start();
                }
                if (this.outStream != null) {
                    this.getOutStream();
                }
            }
        }
    }

    private InStreamDesc createInStreamDesc(SourceStream inStream, InDataSourceDesc inDataSourceDesc) {
        return new InStreamDesc(inStream, inDataSourceDesc);
    }

    public AudioMixingPushBufferDataSource createOutDataSource() {
        return new AudioMixingPushBufferDataSource(this);
    }

    private boolean createTranscodingDataSource(InDataSourceDesc inDataSourceDesc, Format outFormat) throws IOException {
        if (inDataSourceDesc.createTranscodingDataSource(outFormat)) {
            if (this.connected > 0) {
                inDataSourceDesc.connect(this);
            }
            if (this.started > 0) {
                inDataSourceDesc.start();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect() {
        List<InDataSourceDesc> list = this.inDataSources;
        synchronized (list) {
            if (this.connected <= 0) {
                return;
            }
            --this.connected;
            if (this.connected == 0) {
                for (InDataSourceDesc inDataSourceDesc : this.inDataSources) {
                    inDataSourceDesc.disconnect();
                }
                this.outStream.setInStreams(null);
                this.outStream = null;
                this.startedGeneration = 0L;
            }
        }
    }

    BufferControl getBufferControl() {
        BufferControl captureDeviceBufferControl;
        if (this.bufferControl == null && this.captureDevice instanceof Controls && (captureDeviceBufferControl = (BufferControl)((Controls)((Object)this.captureDevice)).getControl(BufferControl.class.getName())) != null) {
            this.bufferControl = new ReadOnlyBufferControlDelegate(captureDeviceBufferControl);
        }
        return this.bufferControl;
    }

    CaptureDeviceInfo getCaptureDeviceInfo() {
        return this.captureDevice.getCaptureDeviceInfo();
    }

    String getContentType() {
        return "raw";
    }

    Time getDuration() {
        return ((DataSource)((Object)this.captureDevice)).getDuration();
    }

    private InStreamDesc getExistingInStreamDesc(SourceStream inStream, InStreamDesc[] existingInStreamDescs) {
        if (existingInStreamDescs == null) {
            return null;
        }
        for (InStreamDesc existingInStreamDesc : existingInStreamDescs) {
            SourceStream existingInStream = existingInStreamDesc.getInStream();
            if (existingInStream == inStream) {
                return existingInStreamDesc;
            }
            if (existingInStream instanceof BufferStreamAdapter && ((BufferStreamAdapter)existingInStream).getStream() == inStream) {
                return existingInStreamDesc;
            }
            if (!(existingInStream instanceof CachingPushBufferStream) || ((CachingPushBufferStream)existingInStream).getStream() != inStream) continue;
            return existingInStreamDesc;
        }
        return null;
    }

    FormatControl[] getFormatControls() {
        FormatControl[] formatControls = this.captureDevice.getFormatControls();
        if (!OSUtils.IS_ANDROID && formatControls != null) {
            for (int i = 0; i < formatControls.length; ++i) {
                formatControls[i] = new ReadOnlyFormatControlDelegate(formatControls[i]);
            }
        }
        return formatControls;
    }

    private boolean getInStreamsFromInDataSource(InDataSourceDesc inDataSourceDesc, AudioFormat outFormat, InStreamDesc[] existingInStreams, List<InStreamDesc> inStreams) {
        SourceStream[] inDataSourceStreams = inDataSourceDesc.getStreams();
        if (inDataSourceStreams != null) {
            boolean added = false;
            for (SourceStream inStream : inDataSourceStreams) {
                Format inFormat = AudioMixer.getFormat(inStream);
                if (inFormat == null || !this.matches(inFormat, outFormat)) continue;
                InStreamDesc inStreamDesc = this.getExistingInStreamDesc(inStream, existingInStreams);
                if (inStreamDesc == null) {
                    inStreamDesc = this.createInStreamDesc(inStream, inDataSourceDesc);
                }
                if (!inStreams.add(inStreamDesc)) continue;
                added = true;
            }
            return added;
        }
        DataSource inDataSource = inDataSourceDesc.getEffectiveInDataSource();
        if (inDataSource == null) {
            return false;
        }
        Format inFormat = AudioMixer.getFormat(inDataSource);
        if (inFormat != null && !this.matches(inFormat, outFormat)) {
            if (inDataSource instanceof PushDataSource) {
                for (PushSourceStream inStream : ((PushDataSource)inDataSource).getStreams()) {
                    InStreamDesc inStreamDesc = this.getExistingInStreamDesc(inStream, existingInStreams);
                    if (inStreamDesc == null) {
                        inStreamDesc = this.createInStreamDesc(new PushBufferStreamAdapter(inStream, inFormat), inDataSourceDesc);
                    }
                    inStreams.add(inStreamDesc);
                }
                return true;
            }
            if (inDataSource instanceof PullDataSource) {
                for (PullSourceStream inStream : ((PullDataSource)inDataSource).getStreams()) {
                    InStreamDesc inStreamDesc = this.getExistingInStreamDesc(inStream, existingInStreams);
                    if (inStreamDesc == null) {
                        inStreamDesc = this.createInStreamDesc(new PullBufferStreamAdapter(inStream, inFormat), inDataSourceDesc);
                    }
                    inStreams.add(inStreamDesc);
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<InStreamDesc> getInStreamsFromInDataSources(AudioFormat outFormat, InStreamDesc[] existingInStreams) throws IOException {
        ArrayList<InStreamDesc> inStreams = new ArrayList<InStreamDesc>();
        List<InDataSourceDesc> list = this.inDataSources;
        synchronized (list) {
            for (InDataSourceDesc inDataSourceDesc : this.inDataSources) {
                boolean got = this.getInStreamsFromInDataSource(inDataSourceDesc, outFormat, existingInStreams, inStreams);
                if (got || !this.createTranscodingDataSource(inDataSourceDesc, outFormat)) continue;
                this.getInStreamsFromInDataSource(inDataSourceDesc, outFormat, existingInStreams, inStreams);
            }
        }
        return inStreams;
    }

    public AudioMixingPushBufferDataSource getLocalOutDataSource() {
        return this.localOutDataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AudioFormat getOutFormatFromInDataSources() {
        String formatControlType = FormatControl.class.getName();
        AudioFormat outFormat = null;
        List<InDataSourceDesc> list = this.inDataSources;
        synchronized (list) {
            for (InDataSourceDesc inDataSource : this.inDataSources) {
                int endian;
                int signed;
                AudioFormat format;
                FormatControl formatControl;
                DataSource effectiveInDataSource = inDataSource.getEffectiveInDataSource();
                if (effectiveInDataSource == null || (formatControl = (FormatControl)effectiveInDataSource.getControl(formatControlType)) == null || (format = (AudioFormat)formatControl.getFormat()) == null || 1 != (signed = format.getSigned()) && -1 != signed || 0 != (endian = format.getEndian()) && -1 != endian) continue;
                outFormat = format;
                break;
            }
        }
        if (outFormat == null) {
            outFormat = DEFAULT_OUTPUT_FORMAT;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Determined outFormat of AudioMixer from inDataSources to be " + outFormat);
        }
        return outFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AudioMixerPushBufferStream getOutStream() {
        List<InDataSourceDesc> list = this.inDataSources;
        synchronized (list) {
            Collection<InStreamDesc> inStreams;
            AudioFormat outFormat = this.outStream == null ? this.getOutFormatFromInDataSources() : this.outStream.getFormat();
            this.setOutFormatToInDataSources(outFormat);
            try {
                inStreams = this.getInStreamsFromInDataSources(outFormat, this.outStream == null ? null : this.outStream.getInStreams());
            }
            catch (IOException ioex) {
                throw new UndeclaredThrowableException(ioex);
            }
            if (this.outStream == null) {
                this.outStream = new AudioMixerPushBufferStream(this, outFormat);
                this.startedGeneration = 0L;
            }
            this.outStream.setInStreams(inStreams);
            return this.outStream;
        }
    }

    public TranscodingDataSource getTranscodingDataSource(DataSource inDataSource) {
        for (InDataSourceDesc inDataSourceDesc : this.inDataSources) {
            DataSource ourDataSource = inDataSourceDesc.getInDataSource();
            if (ourDataSource == inDataSource) {
                return inDataSourceDesc.getTranscodingDataSource();
            }
            if (!(ourDataSource instanceof ReceiveStreamPushBufferDataSource) || ((ReceiveStreamPushBufferDataSource)ourDataSource).getDataSource() != inDataSource) continue;
            return inDataSourceDesc.getTranscodingDataSource();
        }
        return null;
    }

    private boolean matches(Format input, AudioFormat pattern) {
        return input instanceof AudioFormat && input.isSameEncoding(pattern);
    }

    protected void read(PushBufferStream stream, Buffer buffer, DataSource dataSource) throws IOException {
        stream.read(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInDataSources(DataSourceFilter dataSourceFilter) {
        List<InDataSourceDesc> list = this.inDataSources;
        synchronized (list) {
            Iterator<InDataSourceDesc> inDataSourceIter = this.inDataSources.iterator();
            boolean removed = false;
            while (inDataSourceIter.hasNext()) {
                if (!dataSourceFilter.accept(inDataSourceIter.next().inDataSource)) continue;
                inDataSourceIter.remove();
                removed = true;
            }
            if (removed && this.outStream != null) {
                this.getOutStream();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOutFormatToInDataSources(AudioFormat outFormat) {
        String formatControlType = FormatControl.class.getName();
        List<InDataSourceDesc> list = this.inDataSources;
        synchronized (list) {
            for (InDataSourceDesc inDataSourceDesc : this.inDataSources) {
                Format inFormat;
                FormatControl formatControl = (FormatControl)inDataSourceDesc.getControl(formatControlType);
                if (formatControl == null || (inFormat = formatControl.getFormat()) != null && this.matches(inFormat, outFormat)) continue;
                Format setFormat = formatControl.setFormat(outFormat);
                if (setFormat == null) {
                    logger.error("Failed to set format of inDataSource to " + outFormat);
                    continue;
                }
                if (setFormat != outFormat) {
                    logger.warn("Failed to change format of inDataSource from " + setFormat + " to " + outFormat);
                    continue;
                }
                if (!logger.isTraceEnabled()) continue;
                logger.trace("Set format of inDataSource to " + setFormat);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start(AudioMixerPushBufferStream outStream, long generation) throws IOException {
        List<InDataSourceDesc> list = this.inDataSources;
        synchronized (list) {
            if (this.outStream != outStream) {
                return;
            }
            if (this.startedGeneration >= generation) {
                return;
            }
            this.startedGeneration = generation;
            if (this.started == 0) {
                for (InDataSourceDesc inDataSourceDesc : this.inDataSources) {
                    inDataSourceDesc.start();
                }
            }
            ++this.started;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop(AudioMixerPushBufferStream outStream, long generation) throws IOException {
        List<InDataSourceDesc> list = this.inDataSources;
        synchronized (list) {
            if (this.outStream != outStream) {
                return;
            }
            if (this.startedGeneration >= generation) {
                return;
            }
            this.startedGeneration = generation;
            if (this.started <= 0) {
                return;
            }
            --this.started;
            if (this.started == 0) {
                for (InDataSourceDesc inDataSourceDesc : this.inDataSources) {
                    inDataSourceDesc.stop();
                }
            }
        }
    }
}

