/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;

public class Move
extends Copy {
    protected void doFileOperations() {
        Object object;
        Object object2;
        Object object3;
        Enumeration enumeration;
        if (this.completeDirMap.size() > 0) {
            enumeration = this.completeDirMap.keys();
            while (enumeration.hasMoreElements()) {
                object3 = (File)enumeration.nextElement();
                object2 = (File)this.completeDirMap.get(object3);
                try {
                    this.log("Attempting to rename dir: " + object3 + " to " + object2, this.verbosity);
                    this.renameFile((File)object3, (File)object2, this.filtering, this.forceOverwrite);
                }
                catch (IOException iOException) {
                    String string = "Failed to rename dir " + object3 + " to " + object2 + " due to " + iOException.getMessage();
                    throw new BuildException(string, iOException, this.getLocation());
                }
            }
        }
        if (this.fileCopyMap.size() > 0) {
            this.log("Moving " + this.fileCopyMap.size() + " files to " + this.destDir.getAbsolutePath());
            enumeration = this.fileCopyMap.keys();
            while (enumeration.hasMoreElements()) {
                object3 = (String)enumeration.nextElement();
                object2 = new File((String)object3);
                boolean bl = false;
                if (!((File)object2).exists()) continue;
                String[] stringArray = (String[])this.fileCopyMap.get(object3);
                int n = 0;
                while (n < stringArray.length) {
                    object = stringArray[n];
                    if (((String)object3).equals(object)) {
                        this.log("Skipping self-move of " + (String)object3, this.verbosity);
                        bl = true;
                    } else {
                        File file = new File((String)object);
                        if (n + 1 == stringArray.length && !bl) {
                            this.moveFile((File)object2, file, this.filtering, this.forceOverwrite);
                        } else {
                            this.copyFile((File)object2, file, this.filtering, this.forceOverwrite);
                        }
                    }
                    ++n;
                }
            }
        }
        if (this.includeEmpty) {
            enumeration = this.dirCopyMap.keys();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                object2 = (String)enumeration.nextElement();
                String[] stringArray = (String[])this.dirCopyMap.get(object2);
                boolean bl = false;
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (((String)object2).equals(stringArray[n2])) {
                        this.log("Skipping self-move of " + (String)object2, this.verbosity);
                        bl = true;
                    } else {
                        object = new File(stringArray[n2]);
                        if (!((File)object).exists()) {
                            if (!((File)object).mkdirs()) {
                                this.log("Unable to create directory " + ((File)object).getAbsolutePath(), 0);
                            } else {
                                ++n;
                            }
                        }
                    }
                    ++n2;
                }
                File file = new File((String)object2);
                if (bl || !this.okToDelete(file)) continue;
                this.deleteDir(file);
            }
            if (n > 0) {
                this.log("Moved " + this.dirCopyMap.size() + " empty director" + (this.dirCopyMap.size() == 1 ? "y" : "ies") + " to " + n + " empty director" + (n == 1 ? "y" : "ies") + " under " + this.destDir.getAbsolutePath());
            }
        }
    }

    private final void moveFile(File file, File file2, boolean bl, boolean bl2) {
        boolean bl3 = false;
        try {
            this.log("Attempting to rename: " + file + " to " + file2, this.verbosity);
            bl3 = this.renameFile(file, file2, bl, this.forceOverwrite);
        }
        catch (IOException iOException) {
            String string = "Failed to rename " + file + " to " + file2 + " due to " + iOException.getMessage();
            throw new BuildException(string, iOException, this.getLocation());
        }
        if (!bl3) {
            this.copyFile(file, file2, bl, bl2);
            if (!file.delete()) {
                throw new BuildException("Unable to delete file " + file.getAbsolutePath());
            }
        }
    }

    private final void copyFile(File file, File file2, boolean bl, boolean bl2) {
        try {
            this.log("Copying " + file + " to " + file2, this.verbosity);
            FilterSetCollection filterSetCollection = new FilterSetCollection();
            if (bl) {
                filterSetCollection.addFilterSet(this.getProject().getGlobalFilterSet());
            }
            Enumeration enumeration = this.getFilterSets().elements();
            while (enumeration.hasMoreElements()) {
                filterSetCollection.addFilterSet((FilterSet)enumeration.nextElement());
            }
            this.getFileUtils().copyFile(file, file2, filterSetCollection, this.getFilterChains(), this.forceOverwrite, this.getPreserveLastModified(), this.getEncoding(), this.getOutputEncoding(), this.getProject());
        }
        catch (IOException iOException) {
            String string = "Failed to copy " + file + " to " + file2 + " due to " + iOException.getMessage();
            throw new BuildException(string, iOException, this.getLocation());
        }
    }

    protected boolean okToDelete(File file) {
        String[] stringArray = file.list();
        if (stringArray == null) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            File file2 = new File(file, string);
            if (file2.isDirectory()) {
                if (!this.okToDelete(file2)) {
                    return false;
                }
            } else {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected void deleteDir(File file) {
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            File file2 = new File(file, string);
            if (!file2.isDirectory()) {
                throw new BuildException("UNEXPECTED ERROR - The file " + file2.getAbsolutePath() + " should not exist!");
            }
            this.deleteDir(file2);
            ++n;
        }
        this.log("Deleting directory " + file.getAbsolutePath(), this.verbosity);
        if (!file.delete()) {
            throw new BuildException("Unable to delete directory " + file.getAbsolutePath());
        }
    }

    protected boolean renameFile(File file, File file2, boolean bl, boolean bl2) throws IOException, BuildException {
        boolean bl3 = true;
        if (this.getFilterSets() != null && this.getFilterSets().size() > 0 || this.getFilterChains() != null && this.getFilterChains().size() > 0) {
            bl3 = false;
        } else if (!bl) {
            File file3;
            String string = file2.getParent();
            if (string != null && !(file3 = new File(string)).exists()) {
                file3.mkdirs();
            }
            if (file2.exists() && file2.isFile() && !file2.delete()) {
                throw new BuildException("Unable to remove existing file " + file2);
            }
            bl3 = file.renameTo(file2);
        } else {
            bl3 = false;
        }
        return bl3;
    }

    public Move() {
        this.setOverwrite(true);
    }
}

