/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.util.Hashtable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.IdentityMapper;

public class Sync
extends Task {
    private MyCopy _copy;

    public void init() throws BuildException {
        this._copy = new MyCopy();
        this.configureTask(this._copy);
        this._copy.setFiltering(false);
        this._copy.setIncludeEmptyDirs(false);
        this._copy.setPreserveLastModified(true);
    }

    private final void configureTask(Task task) {
        task.setProject(this.getProject());
        task.setTaskName(this.getTaskName());
        task.setOwningTarget(this.getOwningTarget());
        task.init();
    }

    public void execute() throws BuildException {
        File file = this._copy.getToDir();
        Hashtable hashtable = this._copy._dest2src;
        boolean bl = false;
        if (!file.exists() || file.list().length < 1) {
            bl = true;
        }
        boolean bl2 = bl;
        this.log("PASS#1: Copying files to " + file, 4);
        this._copy.execute();
        if (bl2) {
            this.log("NO removing necessary in " + file, 4);
            return;
        }
        this.log("PASS#2: Removing orphan files from " + file, 4);
        int[] nArray = this.removeOrphanFiles(hashtable, file);
        this.logRemovedCount(nArray[0], "dangling director", "y", "ies");
        this.logRemovedCount(nArray[1], "dangling file", "", "s");
        if (!this._copy.getIncludeEmptyDirs()) {
            this.log("PASS#3: Removing empty directories from " + file, 4);
            int n = this.removeEmptyDirectories(file, false);
            this.logRemovedCount(n, "empty director", "y", "ies");
        }
    }

    private final void logRemovedCount(int n, String string, String string2, String string3) {
        File file = this._copy.getToDir();
        String string4 = string == null ? "" : string;
        string4 = string4 + (n < 2 ? string2 : string3);
        if (n > 0) {
            this.log("Removed " + n + ' ' + string4 + " from " + file, 2);
        } else {
            this.log("NO " + string4 + " to remove from " + file, 3);
        }
    }

    private final int[] removeOrphanFiles(Hashtable hashtable, File file) {
        int[] nArray = new int[3];
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                int[] nArray2 = this.removeOrphanFiles(hashtable, fileArray[n]);
                nArray[0] = nArray[0] + nArray2[0];
                nArray[1] = nArray[1] + nArray2[1];
                nArray[2] = nArray[2] + nArray2[2];
                ++n;
            }
            if (hashtable.get(file) == null && nArray[2] == 0) {
                this.log("Removing orphan directory: " + file, 4);
                file.delete();
                nArray[0] = nArray[0] + 1;
            } else {
                nArray[2] = 1;
            }
        } else if (hashtable.get(file) == null) {
            this.log("Removing orphan file: " + file, 4);
            file.delete();
            nArray[1] = nArray[1] + 1;
        } else {
            nArray[2] = 1;
        }
        return nArray;
    }

    private final int removeEmptyDirectories(File file, boolean bl) {
        int n = 0;
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n2 = 0;
            while (n2 < fileArray.length) {
                File file2 = fileArray[n2];
                if (file2.isDirectory()) {
                    n += this.removeEmptyDirectories(file2, true);
                }
                ++n2;
            }
            if (fileArray.length > 0) {
                fileArray = file.listFiles();
            }
            if (fileArray.length < 1 && bl) {
                this.log("Removing empty directory: " + file, 4);
                file.delete();
                ++n;
            }
        }
        return n;
    }

    public void setTodir(File file) {
        this._copy.setTodir(file);
    }

    public void setVerbose(boolean bl) {
        this._copy.setVerbose(bl);
    }

    public void setOverwrite(boolean bl) {
        this._copy.setOverwrite(bl);
    }

    public void setIncludeEmptyDirs(boolean bl) {
        this._copy.setIncludeEmptyDirs(bl);
    }

    public void setFailOnError(boolean bl) {
        this._copy.setFailOnError(bl);
    }

    public void addFileset(FileSet fileSet) {
        this._copy.addFileset(fileSet);
    }

    public void setGranularity(long l) {
        this._copy.setGranularity(l);
    }

    private static final void assertTrue(String string, boolean bl) {
        if (!bl) {
            throw new BuildException("Assertion Error: " + string);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class MyCopy
    extends Copy {
        private Hashtable _dest2src;

        protected void buildMap(File file, File file2, String[] stringArray, FileNameMapper fileNameMapper, Hashtable hashtable) {
            Sync.assertTrue("No mapper", fileNameMapper instanceof IdentityMapper);
            super.buildMap(file, file2, stringArray, fileNameMapper, hashtable);
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                File file3 = new File(file2, string);
                this._dest2src.put(file3, file);
                ++n;
            }
        }

        public File getToDir() {
            return this.destDir;
        }

        public boolean getIncludeEmptyDirs() {
            return this.includeEmpty;
        }

        private final /* synthetic */ void this() {
            this._dest2src = new Hashtable();
        }

        public MyCopy() {
            this.this();
        }
    }
}

