/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.init;

import java.io.File;
import java.lang.reflect.Field;
import java.net.URL;
import org.jdesktop.jdic.browser.WebBrowser;
import org.jdesktop.jdic.browser.WebBrowserUtil;
import org.jdesktop.jdic.init.InitUtility;
import org.jdesktop.jdic.init.JdicInitException;

public class JdicManager {
    private boolean isShareNativeInitialized = false;
    private boolean isBrowserNativeInitialized = false;
    boolean isWindows = System.getProperty("os.name").indexOf("Windows") >= 0;
    String libPathEnv = this.isWindows ? "PATH" : "LD_LIBRARY_PATH";
    String binaryPath = null;
    private static JdicManager sSingleton = null;

    private JdicManager() {
    }

    public static synchronized JdicManager getManager() {
        if (sSingleton == null) {
            sSingleton = new JdicManager();
        }
        return sSingleton;
    }

    public void initShareNative() throws JdicInitException {
        if (this.isShareNativeInitialized) {
            return;
        }
        try {
            String string;
            this.binaryPath = new URL(JdicManager.class.getProtectionDomain().getCodeSource().getLocation(), ".").openConnection().getPermission().getName();
            this.binaryPath = new File(this.binaryPath).getCanonicalPath();
            if (System.getProperty("javawebstart.version") != null) {
                string = "RNjdic-native.jar/";
                this.binaryPath = this.binaryPath + File.separator + string;
            }
            string = this.binaryPath + File.pathSeparator + System.getProperty("java.library.path");
            System.setProperty("java.library.path", string);
            Field field = ClassLoader.class.getDeclaredField("sys_paths");
            field.setAccessible(true);
            if (field != null) {
                field.set(System.class.getClassLoader(), null);
            }
        }
        catch (Throwable throwable) {
            throw new JdicInitException(throwable);
        }
        this.isShareNativeInitialized = true;
    }

    public void initBrowserNative() throws JdicInitException {
        if (this.isBrowserNativeInitialized) {
            return;
        }
        try {
            InitUtility.appendEnv(this.libPathEnv, this.binaryPath);
            String string = WebBrowserUtil.getBrowserPath();
            if (string == null) {
                throw new JdicInitException("Can't locate the native browser path!");
            }
            if (WebBrowserUtil.isDefaultBrowserMozilla()) {
                Object object;
                String string2;
                if (!this.isWindows) {
                    InitUtility.appendEnv("PATH", this.binaryPath);
                    string2 = WebBrowser.getBrowserBinary();
                    Runtime.getRuntime().exec("chmod a+x " + this.binaryPath + File.separator + string2);
                }
                if ((string2 = InitUtility.getEnv("MOZILLA_FIVE_HOME")) == null) {
                    object = new File(string);
                    string2 = ((File)object).isDirectory() ? ((File)object).getCanonicalPath() : ((File)object).getCanonicalFile().getParent();
                    InitUtility.appendEnv("MOZILLA_FIVE_HOME", string2);
                    InitUtility.appendEnv(this.libPathEnv, string2);
                }
                if (this.isWindows) {
                    object = this.binaryPath + File.separator + "MozEmbed.exe";
                    String string3 = string2 + File.separator + "MozEmbed.exe";
                    InitUtility.copyFile((String)object, string3);
                }
            }
        }
        catch (Throwable throwable) {
            throw new JdicInitException(throwable);
        }
        this.isBrowserNativeInitialized = true;
    }
}

