/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.tx;

import com.hazelcast.map.operation.KeyBasedMapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupOperation;
import com.hazelcast.transaction.TransactionException;
import java.io.IOException;

public class TxnPrepareBackupOperation
extends KeyBasedMapOperation
implements BackupOperation {
    private String lockOwner;
    private int lockThreadId;

    protected TxnPrepareBackupOperation(String name, Data dataKey, String lockOwner, int lockThreadId) {
        super(name, dataKey);
        this.lockOwner = lockOwner;
        this.lockThreadId = lockThreadId;
    }

    public TxnPrepareBackupOperation() {
    }

    @Override
    public void run() throws Exception {
        if (!this.recordStore.txnLock(this.getKey(), this.lockOwner, this.lockThreadId, 10000L)) {
            throw new TransactionException("Lock is not owned by the transaction! Owner: " + this.recordStore.getLockOwnerInfo(this.getKey()));
        }
    }

    @Override
    public Object getResponse() {
        return Boolean.TRUE;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.lockOwner);
        out.writeInt(this.lockThreadId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.lockOwner = in.readUTF();
        this.lockThreadId = in.readInt();
    }
}

