/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.whiteboard;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.java.sip.communicator.impl.protocol.jabber.extensions.whiteboard.WhiteboardObjectJabberImpl;
import net.java.sip.communicator.service.protocol.WhiteboardPoint;
import net.java.sip.communicator.service.protocol.whiteboardobjects.WhiteboardObjectPolygon;
import net.java.sip.communicator.util.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WhiteboardObjectPolygonJabberImpl
extends WhiteboardObjectJabberImpl
implements WhiteboardObjectPolygon {
    private static final Logger logger = Logger.getLogger(WhiteboardObjectPolygonJabberImpl.class);
    private List<WhiteboardPoint> listPoints;
    private boolean fill;
    private int backColor;

    public WhiteboardObjectPolygonJabberImpl() {
        this.listPoints = new LinkedList<WhiteboardPoint>();
    }

    public WhiteboardObjectPolygonJabberImpl(String xml) {
        block7: {
            this.listPoints = new LinkedList<WhiteboardPoint>();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
                Document doc = builder.parse(in);
                Element e = doc.getDocumentElement();
                String elementName = e.getNodeName();
                if (elementName.equals("polygon")) {
                    String id = e.getAttribute("id");
                    String d = e.getAttribute("points");
                    String stroke = e.getAttribute("stroke");
                    String stroke_width = e.getAttribute("stroke-width");
                    String fill = e.getAttribute("fill");
                    this.setID(id);
                    this.setThickness(Integer.parseInt(stroke_width));
                    this.setColor(Color.decode(stroke).getRGB());
                    this.setPoints(this.getPolyPoints(d));
                    this.setFill(!fill.equals("none"));
                }
            }
            catch (ParserConfigurationException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Problem WhiteboardObject : " + xml));
                }
            }
            catch (IOException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Problem WhiteboardObject : " + xml));
                }
            }
            catch (Exception ex) {
                if (!logger.isDebugEnabled()) break block7;
                logger.debug((Object)("Problem WhiteboardObject : " + xml));
            }
        }
    }

    public void setPoints(List<WhiteboardPoint> points) {
        this.listPoints = new LinkedList<WhiteboardPoint>(points);
    }

    public List<WhiteboardPoint> getPoints() {
        return this.listPoints;
    }

    private List<WhiteboardPoint> getPolyPoints(String points) {
        LinkedList<WhiteboardPoint> list = new LinkedList<WhiteboardPoint>();
        if (points == null) {
            return list;
        }
        StringTokenizer tokenizer = new StringTokenizer(points);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            String[] coords = token.split(",");
            WhiteboardPoint p = new WhiteboardPoint(Double.parseDouble(coords[0]), Double.parseDouble(coords[1]));
            list.add(p);
        }
        return list;
    }

    public boolean isFill() {
        return this.fill;
    }

    public void setFill(boolean fill) {
        this.fill = fill;
    }

    public void setBackgroundColor(int backColor) {
        this.backColor = backColor;
    }

    public int getBackgroundColor() {
        return this.backColor;
    }

    @Override
    public String toXML() {
        String s = "<polygon id=\"#i\" points=\"#p\" fill=\"#f\" stroke=\"#s\" stroke-width=\"#w\"/>";
        s = s.replaceAll("#i", this.getID());
        s = s.replaceAll("#s", this.colorToHex(this.getColor()));
        s = s.replaceAll("#w", "" + this.getThickness());
        s = s.replaceAll("#f", this.isFill() ? this.colorToHex(this.getColor()) : "none");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.listPoints.size(); ++i) {
            WhiteboardPoint point = this.listPoints.get(i);
            sb.append(point.getX());
            sb.append(",");
            sb.append(point.getY());
            sb.append(" ");
        }
        s = s.replaceAll("#p", sb.toString());
        return s;
    }
}

