/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Transport {
    TCP("tcp"),
    UDP("udp"),
    TLS("tls"),
    DTLS("dtls"),
    SCTP("sctp"),
    SSLTCP("ssltcp");

    private final String transportName;

    private Transport(String transportName) {
        this.transportName = transportName;
    }

    public String toString() {
        return this.transportName;
    }

    public static Transport parse(String transportName) throws IllegalArgumentException {
        if (UDP.toString().equals(transportName)) {
            return UDP;
        }
        if (TCP.toString().equals(transportName)) {
            return TCP;
        }
        if (TLS.toString().equals(transportName)) {
            return TLS;
        }
        if (SCTP.toString().equals(transportName)) {
            return SCTP;
        }
        if (DTLS.toString().equals(transportName)) {
            return DTLS;
        }
        throw new IllegalArgumentException(transportName + " is not a currently supported Transport");
    }
}

