/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform;

import java.io.IOException;
import java.net.DatagramSocket;
import java.util.LinkedList;
import java.util.List;
import javax.media.Buffer;
import org.jitsi.impl.neomedia.RTCPConnectorInputStream;
import org.jitsi.impl.neomedia.transform.TransformUDPInputStream;
import org.jitsi.service.neomedia.event.RTCPFeedbackListener;

public class ControlTransformInputStream
extends TransformUDPInputStream {
    private final List<RTCPFeedbackListener> listeners = new LinkedList<RTCPFeedbackListener>();

    public ControlTransformInputStream(DatagramSocket socket) {
        super(socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRTCPFeedbackListener(RTCPFeedbackListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        List<RTCPFeedbackListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRTCPFeedbackListener(RTCPFeedbackListener listener) {
        if (listener != null) {
            List<RTCPFeedbackListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(listener);
            }
        }
    }

    @Override
    protected int read(Buffer buffer, byte[] data, int offset, int length) throws IOException {
        int pktLength = super.read(buffer, data, offset, length);
        RTCPConnectorInputStream.fireRTCPFeedbackReceived(this, data, offset, pktLength, this.listeners);
        return pktLength;
    }
}

