/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.notify;

import java.io.IOException;
import java.io.InputStream;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.PlugIn;
import javax.media.Renderer;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.codec.audio.speex.SpeexResampler;
import org.jitsi.impl.neomedia.device.AudioSystem;
import org.jitsi.service.audionotifier.AbstractSCAudioClip;
import org.jitsi.service.audionotifier.AudioNotifierService;
import org.jitsi.util.Logger;

public class AudioSystemClipImpl
extends AbstractSCAudioClip {
    private static final int DEFAULT_BUFFER_DATA_LENGTH = 8192;
    private static final Logger logger = Logger.getLogger(AudioSystemClipImpl.class);
    private static final long MIN_AUDIO_STREAM_DURATION = 200L;
    private final AudioSystem audioSystem;
    private Buffer buffer;
    private byte[] bufferData;
    private final boolean playback;
    private Renderer renderer;

    public AudioSystemClipImpl(String url, AudioNotifierService audioNotifier, AudioSystem audioSystem, boolean playback) throws IOException {
        super(url, audioNotifier);
        this.audioSystem = audioSystem;
        this.playback = playback;
    }

    @Override
    protected void enterRunInPlayThread() {
        this.buffer = new Buffer();
        this.bufferData = new byte[8192];
        this.buffer.setData(this.bufferData);
        this.renderer = this.audioSystem.createRenderer(this.playback);
    }

    @Override
    protected void exitRunInPlayThread() {
        this.buffer = null;
        this.bufferData = null;
        this.renderer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void exitRunOnceInPlayThread() {
        try {
            this.renderer.stop();
        }
        finally {
            this.renderer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    protected boolean runOnceInPlayThread() {
        Buffer resamplerBuffer;
        AudioFormat resamplerFormat;
        Format rendererFormat;
        InputStream audioStream = null;
        try {
            audioStream = this.audioSystem.getAudioInputStream(this.uri);
        }
        catch (IOException ioex) {
            logger.error("Failed to get audio stream " + this.uri, ioex);
        }
        if (audioStream == null) {
            return false;
        }
        PlugIn resampler = null;
        boolean success = true;
        AudioFormat audioStreamFormat = null;
        int audioStreamLength = 0;
        long rendererProcessStartTime = 0L;
        try {
            rendererFormat = audioStreamFormat = this.audioSystem.getFormat(audioStream);
            if (rendererFormat == null) {
                boolean bl = false;
                return bl;
            }
            resamplerFormat = null;
            if (this.renderer.setInputFormat(rendererFormat) == null) {
                resampler = new SpeexResampler();
                resamplerFormat = rendererFormat;
                resampler.setInputFormat(resamplerFormat);
                Format[] supportedResamplerFormats = resampler.getSupportedOutputFormats(resamplerFormat);
                block35: for (Format supportedRendererFormat : this.renderer.getSupportedInputFormats()) {
                    for (Format supportedResamplerFormat : supportedResamplerFormats) {
                        if (!supportedRendererFormat.matches(supportedResamplerFormat)) continue;
                        rendererFormat = supportedRendererFormat;
                        resampler.setOutputFormat(rendererFormat);
                        this.renderer.setInputFormat(rendererFormat);
                        continue block35;
                    }
                }
            }
        }
        catch (ResourceUnavailableException ruex) {
            if (resampler == null) return success;
            logger.error("Failed to open " + resampler.getClass().getName(), ruex);
            success = false;
            return success;
        }
        Buffer rendererBuffer = this.buffer;
        rendererBuffer.setFormat(rendererFormat);
        if (resampler == null) {
            resamplerBuffer = null;
        } else {
            resamplerBuffer = new Buffer();
            int bufferDataLength = 8192;
            if (resamplerFormat instanceof AudioFormat) {
                AudioFormat af = resamplerFormat;
                int frameSize = af.getSampleSizeInBits() / 8 * af.getChannels();
                bufferDataLength = bufferDataLength / frameSize * frameSize;
            }
            this.bufferData = new byte[bufferDataLength];
            resamplerBuffer.setData(this.bufferData);
            resamplerBuffer.setFormat(resamplerFormat);
            resampler.open();
        }
        try {
            this.renderer.open();
            this.renderer.start();
            block37: while (this.isStarted()) {
                int rendererProcess;
                int bufferLength = audioStream.read(this.bufferData);
                if (bufferLength == -1) return success;
                audioStreamLength += bufferLength;
                if (resampler == null) {
                    rendererBuffer.setLength(bufferLength);
                    rendererBuffer.setOffset(0);
                } else {
                    resamplerBuffer.setLength(bufferLength);
                    resamplerBuffer.setOffset(0);
                    rendererBuffer.setLength(0);
                    rendererBuffer.setOffset(0);
                    resampler.process(resamplerBuffer, rendererBuffer);
                }
                if (rendererProcessStartTime == 0L) {
                    rendererProcessStartTime = System.currentTimeMillis();
                }
                do {
                    if ((rendererProcess = this.renderer.process(rendererBuffer)) != 1) continue;
                    logger.error("Failed to render audio stream " + this.uri);
                    success = false;
                    continue block37;
                } while ((rendererProcess & 2) == 2);
            }
            return success;
        }
        catch (IOException ioex) {
            logger.error("Failed to read from audio stream " + this.uri, ioex);
            return false;
        }
        catch (ResourceUnavailableException ruex) {
            logger.error("Failed to open " + this.renderer.getClass().getName(), ruex);
            return false;
        }
        finally {
            long audioStreamDuration;
            try {
                audioStream.close();
            }
            catch (IOException ioex) {}
            if (resampler != null) {
                resampler.close();
            }
            if (success && audioStreamFormat != null && audioStreamLength > 0 && rendererProcessStartTime > 0L && this.isStarted() && (audioStreamDuration = (audioStreamFormat.computeDuration(audioStreamLength) + 999999L) / 1000000L) > 0L) {
                audioStreamDuration += 200L;
                boolean interrupted = false;
                Object object = this.sync;
            }
        }
    }
}

