/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.tx;

import com.hazelcast.map.operation.BasePutOperation;
import com.hazelcast.map.operation.PutBackupOperation;
import com.hazelcast.map.record.Record;
import com.hazelcast.map.tx.MapTxnOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.ResponseHandler;
import com.hazelcast.spi.WaitNotifyKey;
import java.io.IOException;

public class TxnSetOperation
extends BasePutOperation
implements MapTxnOperation {
    private long version;
    private boolean shouldBackup = false;

    public TxnSetOperation() {
    }

    public TxnSetOperation(String name, Data dataKey, Data value, long ttl, long version) {
        super(name, dataKey, value, ttl);
        this.version = version;
    }

    @Override
    public void run() {
        this.recordStore.unlock(this.dataKey, this.getCallerUuid(), this.getThreadId());
        Record record = this.recordStore.getRecord(this.dataKey);
        if (record == null || this.version == record.getVersion()) {
            this.recordStore.set(this.dataKey, this.dataValue, this.ttl);
            this.shouldBackup = true;
        }
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(long version) {
        this.version = version;
    }

    @Override
    public Object getResponse() {
        return Boolean.TRUE;
    }

    @Override
    public boolean shouldNotify() {
        return true;
    }

    @Override
    public Operation getBackupOperation() {
        return new PutBackupOperation(this.name, this.dataKey, this.dataValue, this.ttl, true);
    }

    @Override
    public void onWaitExpire() {
        ResponseHandler responseHandler = this.getResponseHandler();
        responseHandler.sendResponse(false);
    }

    @Override
    public boolean shouldBackup() {
        return this.shouldBackup;
    }

    @Override
    public WaitNotifyKey getNotifiedKey() {
        return this.getWaitKey();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.version);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.version = in.readLong();
    }
}

