/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.txn;

import com.hazelcast.collection.CollectionBackupAwareOperation;
import com.hazelcast.collection.CollectionDataSerializerHook;
import com.hazelcast.collection.txn.CollectionPrepareBackupOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class CollectionPrepareOperation
extends CollectionBackupAwareOperation {
    private long itemId = -1L;
    boolean removeOperation;
    String transactionId;

    public CollectionPrepareOperation() {
    }

    public CollectionPrepareOperation(String name, long itemId, String transactionId, boolean removeOperation) {
        super(name);
        this.itemId = itemId;
        this.removeOperation = removeOperation;
        this.transactionId = transactionId;
    }

    @Override
    public boolean shouldBackup() {
        return true;
    }

    @Override
    public Operation getBackupOperation() {
        return new CollectionPrepareBackupOperation(this.name, this.itemId, this.transactionId, this.removeOperation);
    }

    @Override
    public int getId() {
        return CollectionDataSerializerHook.COLLECTION_PREPARE;
    }

    @Override
    public void beforeRun() throws Exception {
    }

    @Override
    public void run() throws Exception {
        this.getOrCreateContainer().ensureReserve(this.itemId);
    }

    @Override
    public void afterRun() throws Exception {
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.itemId);
        out.writeBoolean(this.removeOperation);
        out.writeUTF(this.transactionId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.itemId = in.readLong();
        this.removeOperation = in.readBoolean();
        this.transactionId = in.readUTF();
    }
}

