/*
 * Decompiled with CFR 0.152.
 */
package ymsg.network;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.net.Socket;
import java.util.Properties;
import java.util.Vector;
import ymsg.network.ConnectionHandler;
import ymsg.network.NetworkConstants;
import ymsg.network.PacketBodyBuffer;
import ymsg.network.ServiceConstants;
import ymsg.network.Session;
import ymsg.network.Util;
import ymsg.network.YMSG9InputStream;
import ymsg.network.YMSG9Packet;

public class HTTPConnectionHandler
extends ConnectionHandler
implements ServiceConstants,
NetworkConstants {
    private ThreadGroup threadGroup;
    private Session session;
    private String proxyHost;
    private int proxyPort;
    private long lastFetch;
    private Vector packets;
    private boolean connected = false;
    private boolean quitFlag = false;
    private String cookie = null;
    private long identifier = 0L;
    private Notifier notifierThread;
    private static final long IDLE_TIMEOUT = 30000L;
    private String headerHttpPost;
    private String headerAgent;
    private String headerHost;
    private String headerProxyAuth;

    public HTTPConnectionHandler() throws IllegalArgumentException {
        this._init();
        this.proxyHost = Util.httpProxyHost();
        this.proxyPort = Util.httpProxyPort();
        if (this.proxyHost == null || this.proxyPort <= 0) {
            throw new IllegalArgumentException("Bad HTTP proxy properties");
        }
    }

    public HTTPConnectionHandler(String string, int n, String string2) {
        this._init();
        this.proxyHost = string;
        this.proxyPort = n;
        Properties properties = System.getProperties();
        properties.put("proxyHost", this.proxyHost);
        properties.put("http.proxyHost", this.proxyHost);
        properties.put("proxyPort", this.proxyPort + "");
        properties.put("http.proxyPort", this.proxyPort + "");
        properties.put("proxySet", "true");
        if (string2 != null) {
            properties.put("http.nonProxyHosts", string2);
        } else {
            properties.remove("http.nonProxyHosts");
        }
    }

    public HTTPConnectionHandler(String string, int n, Vector vector) {
        this(string, n, (String)null);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < vector.size(); ++i) {
            stringBuffer.append((String)vector.elementAt(i));
            if (i + 1 >= vector.size()) continue;
            stringBuffer.append("|");
        }
        System.getProperties().put("http.nonProxyHosts", stringBuffer.toString());
    }

    public HTTPConnectionHandler(String string, int n) {
        this(string, n, (String)null);
    }

    private void _init() {
        this.packets = new Vector(5);
        this.connected = false;
        String string = Util.httpHost();
        this.headerHttpPost = "POST http://" + string + "/notify HTTP/1.0" + "\n";
        this.headerAgent = "User-Agent: Mozilla/4.5 [en] (X11; U; FreeBSD 2.2.8-STABLE i386)\n";
        this.headerHost = "Host: " + string + "\n";
        this.headerProxyAuth = "Proxy-Authorization: " + Util.httpProxyAuth() + "\n";
    }

    public static void setProxyAuthorizationProperty(String string, String string2, String string3) throws UnsupportedOperationException {
        if (!string.equalsIgnoreCase("basic")) {
            throw new UnsupportedOperationException("Method " + string + " unsupported.");
        }
        String string4 = string2 + ":" + string3;
        String string5 = "Basic " + Util.base64(string4.getBytes());
        System.setProperty("ymsg.network.httpProxyAuth", string5);
    }

    void install(Session session, ThreadGroup threadGroup) {
        this.session = session;
        this.threadGroup = threadGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void open() {
        this.connected = true;
        HTTPConnectionHandler hTTPConnectionHandler = this;
        synchronized (hTTPConnectionHandler) {
            if (this.notifierThread == null) {
                this.notifierThread = new Notifier(this.threadGroup, "HTTP Notifier");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        this.connected = false;
        HTTPConnectionHandler hTTPConnectionHandler = this;
        synchronized (hTTPConnectionHandler) {
            if (this.notifierThread != null) {
                this.notifierThread.quitFlag = true;
                this.notifierThread = null;
            }
        }
    }

    synchronized void sendPacket(PacketBodyBuffer packetBodyBuffer, int n, long l, long l2) throws IOException, IllegalStateException {
        if (!this.connected) {
            throw new IllegalStateException("Not logged in");
        }
        if (this.filterOutput(packetBodyBuffer, n)) {
            return;
        }
        byte[] byArray = packetBodyBuffer.getBuffer();
        Socket socket = new Socket(this.proxyHost, this.proxyPort);
        PushbackInputStream pushbackInputStream = new PushbackInputStream(socket.getInputStream());
        DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
        dataOutputStream.writeBytes(this.headerHttpPost);
        dataOutputStream.writeBytes("Content-length: " + (byArray.length + 20) + "\n");
        dataOutputStream.writeBytes(this.headerAgent);
        dataOutputStream.writeBytes(this.headerHost);
        if (this.headerProxyAuth != null) {
            dataOutputStream.writeBytes(this.headerProxyAuth);
        }
        if (this.cookie != null) {
            dataOutputStream.writeBytes("Cookie: " + this.cookie + "\n");
        }
        dataOutputStream.writeBytes("\n");
        dataOutputStream.write(MAGIC, 0, 4);
        dataOutputStream.write(VERSION_HTTP, 0, 4);
        dataOutputStream.writeShort(byArray.length & 0xFFFF);
        dataOutputStream.writeShort(n & 0xFFFF);
        dataOutputStream.writeInt((int)(l & 0xFFFFFFFFFFFFFFFFL));
        dataOutputStream.writeInt((int)(l2 & 0xFFFFFFFFFFFFFFFFL));
        dataOutputStream.write(byArray, 0, byArray.length);
        dataOutputStream.flush();
        String string = this.readLine(pushbackInputStream);
        if (string == null || string.indexOf(" 200 ") < 0) {
            return;
        }
        while (string != null && string.trim().length() > 0) {
            string = this.readLine(pushbackInputStream);
        }
        byte[] byArray2 = new byte[4];
        pushbackInputStream.read(byArray2, 0, 4);
        int n2 = byArray2[0];
        YMSG9InputStream yMSG9InputStream = new YMSG9InputStream(pushbackInputStream);
        try {
            for (int i = 0; i < n2; ++i) {
                YMSG9Packet yMSG9Packet = yMSG9InputStream.readPacket();
                if (this.filterInput(yMSG9Packet)) continue;
                this.push(yMSG9Packet);
            }
        }
        catch (Exception exception) {
            this.push(exception);
        }
        if (Util.debugMode) {
            System.out.println("Size:" + this.packets.size());
        }
        socket.close();
        this.lastFetch = System.currentTimeMillis();
    }

    private String readLine(PushbackInputStream pushbackInputStream) throws IOException {
        int n = pushbackInputStream.read();
        String string = "";
        while (n != 10 && n != 13) {
            string = string + (char)n;
            n = pushbackInputStream.read();
        }
        int n2 = pushbackInputStream.read();
        if (n == 10 && n2 != 13 || n == 13 && n2 != 10) {
            pushbackInputStream.unread(n2);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    YMSG9Packet receivePacket() throws IOException {
        if (!this.connected) {
            throw new IllegalStateException("Not logged in");
        }
        while (true) {
            HTTPConnectionHandler hTTPConnectionHandler = this;
            synchronized (hTTPConnectionHandler) {
                if (this.packets.size() > 0) {
                    Object object = this.pull();
                    if (object instanceof IOException) {
                        throw (IOException)object;
                    }
                    return (YMSG9Packet)object;
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private boolean filterOutput(PacketBodyBuffer packetBodyBuffer, int n) {
        switch (n) {
            case 2: 
            case 4: {
                return true;
            }
        }
        if (this.identifier > 0L) {
            packetBodyBuffer.addElement("24", this.identifier + "");
        }
        return false;
    }

    private boolean filterInput(YMSG9Packet yMSG9Packet) {
        switch (yMSG9Packet.service) {
            case 85: {
                String[] stringArray = HTTPConnectionHandler.extractCookies(yMSG9Packet);
                this.cookie = stringArray[0] + "; " + stringArray[1];
                break;
            }
            case 1: {
                try {
                    this.identifier = Long.parseLong(yMSG9Packet.getValue("24"));
                }
                catch (NumberFormatException numberFormatException) {
                    this.identifier = 0L;
                }
                break;
            }
            case 6: {
                if (yMSG9Packet.getValue("14") != null) break;
                if (yMSG9Packet.getValue("10") != null) {
                    yMSG9Packet.service = 4;
                    break;
                }
                if (yMSG9Packet.body.length != 0) break;
                return true;
            }
        }
        return false;
    }

    private synchronized Object pull() {
        if (this.packets.size() <= 0) {
            return null;
        }
        Object e = this.packets.elementAt(0);
        this.packets.removeElementAt(0);
        return e;
    }

    private synchronized void push(Object object) {
        this.packets.addElement(object);
    }

    public String toString() {
        return "HTTP connection: " + this.proxyHost + ":" + this.proxyPort;
    }

    class Notifier
    extends Thread {
        boolean quitFlag;

        Notifier(ThreadGroup threadGroup, String string) {
            super(threadGroup, string);
            this.quitFlag = false;
            HTTPConnectionHandler.this.lastFetch = System.currentTimeMillis();
            this.start();
        }

        public void run() {
            while (!this.quitFlag) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                long l = System.currentTimeMillis();
                if (this.quitFlag || !HTTPConnectionHandler.this.connected || l - HTTPConnectionHandler.this.lastFetch <= 30000L || HTTPConnectionHandler.this.session.getSessionStatus() != 2) continue;
                try {
                    HTTPConnectionHandler.this.session.transmitIdle();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

