/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.tx;

import com.hazelcast.concurrent.lock.LockWaitNotifyKey;
import com.hazelcast.map.operation.KeyBasedMapOperation;
import com.hazelcast.map.tx.TxnRollbackBackupOperation;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.DefaultObjectNamespace;
import com.hazelcast.spi.Notifier;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.WaitNotifyKey;
import com.hazelcast.transaction.TransactionException;

public class TxnRollbackOperation
extends KeyBasedMapOperation
implements BackupAwareOperation,
Notifier {
    protected TxnRollbackOperation(String name, Data dataKey) {
        super(name, dataKey);
    }

    public TxnRollbackOperation() {
    }

    @Override
    public void run() throws Exception {
        if (this.recordStore.isLocked(this.getKey()) && !this.recordStore.unlock(this.getKey(), this.getCallerUuid(), this.getThreadId())) {
            throw new TransactionException("Lock is not owned by the transaction! Owner: " + this.recordStore.getLockOwnerInfo(this.getKey()));
        }
    }

    @Override
    public Object getResponse() {
        return Boolean.TRUE;
    }

    @Override
    public boolean shouldBackup() {
        return true;
    }

    @Override
    public final Operation getBackupOperation() {
        return new TxnRollbackBackupOperation(this.name, this.dataKey, this.getCallerUuid(), this.getThreadId());
    }

    @Override
    public final int getAsyncBackupCount() {
        return this.mapContainer.getAsyncBackupCount();
    }

    @Override
    public final int getSyncBackupCount() {
        return this.mapContainer.getBackupCount();
    }

    @Override
    public boolean shouldNotify() {
        return true;
    }

    @Override
    public WaitNotifyKey getNotifiedKey() {
        return new LockWaitNotifyKey(new DefaultObjectNamespace("hz:impl:mapService", this.name), this.dataKey);
    }
}

