/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection;

import com.hazelcast.collection.CollectionDataSerializerHook;
import com.hazelcast.collection.CollectionOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupOperation;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class CollectionAddAllBackupOperation
extends CollectionOperation
implements BackupOperation {
    protected Map<Long, Data> valueMap;

    public CollectionAddAllBackupOperation() {
    }

    public CollectionAddAllBackupOperation(String name, Map<Long, Data> valueMap) {
        super(name);
        this.valueMap = valueMap;
    }

    @Override
    public int getId() {
        return CollectionDataSerializerHook.COLLECTION_ADD_ALL_BACKUP;
    }

    @Override
    public void beforeRun() throws Exception {
    }

    @Override
    public void run() throws Exception {
        this.getOrCreateContainer().addAllBackup(this.valueMap);
    }

    @Override
    public void afterRun() throws Exception {
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.valueMap.size());
        for (Map.Entry<Long, Data> entry : this.valueMap.entrySet()) {
            out.writeLong(entry.getKey());
            entry.getValue().writeData(out);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        this.valueMap = new HashMap<Long, Data>(size);
        for (int i = 0; i < size; ++i) {
            long itemId = in.readLong();
            Data value = new Data();
            value.readData(in);
            this.valueMap.put(itemId, value);
        }
    }
}

