/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.logging;

import com.voxeo.logging.LogViewerTcpConnectionUpdates;
import com.voxeo.logging.LogViewerTcpHost;
import com.voxeo.processor.AProcessorItem;
import com.voxeo.processor.Processor;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.helpers.LogLog;

public class LogViewerTcpWriter
extends Writer {
    private static final int CONNECT_TIMEOUT = 5000;
    private static final int SYSLOG_PORT = 514;
    private final LogViewerTcpConnection logViewerTcpConnection;
    private final Processor processor = new Processor("Log Viewer Tcp Processor", 1);
    private final int maxMsgLength;
    private final int maxQueueSize;

    public LogViewerTcpWriter(String syslogHosts, int maxMsgLength, int maxQueueSize) {
        this.maxMsgLength = maxMsgLength;
        this.maxQueueSize = maxQueueSize;
        if (syslogHosts == null) {
            throw new NullPointerException("syslogHost");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(syslogHosts, ",");
        ArrayList<LogViewerTcpHost> hosts = new ArrayList<LogViewerTcpHost>();
        ArrayList<PredefinedLogViewerConnections> predefinedConnections = new ArrayList<PredefinedLogViewerConnections>();
        while (stringTokenizer.hasMoreTokens()) {
            String host = stringTokenizer.nextToken();
            int urlPort = -1;
            if (host.startsWith("#") && host.indexOf(123) == host.lastIndexOf(123) && host.indexOf(125) == host.lastIndexOf(125)) {
                String predefDestination = host.substring(host.indexOf(123) + 1, host.indexOf(125));
                PredefinedLogViewerConnections predefinedLogViewerConnection = null;
                for (PredefinedLogViewerConnections conn : PredefinedLogViewerConnections.values()) {
                    if (!conn.toString().equals(predefDestination.toUpperCase())) continue;
                    predefinedLogViewerConnection = conn;
                }
                if (predefinedLogViewerConnection == null) {
                    LogLog.error((String)("Undefined destination " + predefDestination));
                    continue;
                }
                int port = -1;
                int portStartPos = host.indexOf(58) + 1;
                if (portStartPos > 0) {
                    try {
                        port = Integer.parseInt(host.substring(portStartPos));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (port <= 0) {
                    LogLog.error((String)"Invalid port");
                    continue;
                }
                predefinedConnections.add(predefinedLogViewerConnection);
                predefinedLogViewerConnection.setPort(port);
                hosts.add(predefinedLogViewerConnection.getLogViewerTcpHost());
                continue;
            }
            if (host.indexOf("[") != -1 || host.indexOf(58) == host.lastIndexOf(58)) {
                try {
                    URL url = new URL("http://" + host);
                    if (url.getHost() != null) {
                        host = url.getHost();
                        if (host.startsWith("[") && host.charAt(host.length() - 1) == ']') {
                            host = host.substring(1, host.length() - 1);
                        }
                        urlPort = url.getPort();
                    }
                }
                catch (MalformedURLException e) {
                    LogLog.error((String)"Malformed URL: will attempt to interpret as InetAddress.", (Throwable)e);
                }
            }
            if (urlPort == -1) {
                urlPort = 514;
            }
            hosts.add(new LogViewerTcpHost(host, urlPort));
        }
        if (hosts.size() > 0) {
            this.logViewerTcpConnection = new LogViewerTcpConnection(hosts);
            for (PredefinedLogViewerConnections connection : predefinedConnections) {
                connection.setLogViewerTcpConnectionUpdater(this.logViewerTcpConnection);
            }
        } else {
            this.logViewerTcpConnection = null;
        }
    }

    public void write(String string) throws IOException {
        byte[] bytes = string.getBytes();
        this.write(bytes);
    }

    public void write(char[] buf, int off, int len) throws IOException {
        this.write(new String(buf, off, len));
    }

    public void write(byte[] bytes) {
        if (this.logViewerTcpConnection != null && this.processor.getQueueSize() <= this.maxQueueSize) {
            int len = bytes.length;
            this.processor.add(new LogViewerTcpMessage(bytes, len > this.maxMsgLength ? this.maxMsgLength : len));
        }
    }

    public void flush() {
        this.logViewerTcpConnection.flush();
    }

    public void close() {
        this.logViewerTcpConnection.close();
        this.processor.close();
    }

    class LogViewerTcpMessage
    extends AProcessorItem {
        private final byte[] bytes;
        private final int len;

        public LogViewerTcpMessage(byte[] bytes, int len) {
            this.bytes = bytes;
            this.len = len;
        }

        protected void process() {
            LogViewerTcpWriter.this.logViewerTcpConnection.send(this.bytes, this.len);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LogViewerTcpConnection
    implements LogViewerTcpConnectionUpdates {
        private final List<LogViewerTcpHost> hosts;
        private final AtomicInteger hostIndex = new AtomicInteger(0);
        private Socket skt;
        private OutputStream sktOs;
        private boolean closed = false;

        public LogViewerTcpConnection(List<LogViewerTcpHost> hosts) {
            this.hosts = hosts;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            this.closed = true;
            try {
                LogViewerTcpConnection logViewerTcpConnection = this;
                synchronized (logViewerTcpConnection) {
                    if (this.skt != null) {
                        this.skt.close();
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() {
            try {
                LogViewerTcpConnection logViewerTcpConnection = this;
                synchronized (logViewerTcpConnection) {
                    if (this.skt != null) {
                        this.sktOs.flush();
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private synchronized boolean removeConnectionHost(LogViewerTcpHost host) {
            return this.hosts.remove(host);
        }

        private synchronized boolean updateConnectionHost(LogViewerTcpHost prevHost, LogViewerTcpHost newHost) {
            int index = this.hosts.indexOf(prevHost);
            if (index != -1) {
                this.hosts.set(index, newHost);
                return true;
            }
            this.hosts.add(newHost);
            return false;
        }

        @Override
        public void removeHost(LogViewerTcpHost host) {
            if (this.removeConnectionHost(host)) {
                this.hostIndex.set(0);
                this.close();
            }
        }

        @Override
        public void updateHost(LogViewerTcpHost prevHost, LogViewerTcpHost newHost) {
            this.updateConnectionHost(prevHost, newHost);
            this.hostIndex.set(0);
            this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void connect() {
            boolean connected = false;
            while (!connected) {
                ArrayList<LogViewerTcpHost> currHosts;
                LogViewerTcpConnection logViewerTcpConnection = this;
                synchronized (logViewerTcpConnection) {
                    currHosts = new ArrayList<LogViewerTcpHost>(this.hosts);
                }
                if (currHosts.size() == 0) {
                    return;
                }
                if (this.hostIndex.compareAndSet(currHosts.size(), 0)) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                LogViewerTcpHost logViewerTcpHost = (LogViewerTcpHost)currHosts.get(this.hostIndex.get());
                this.hostIndex.incrementAndGet();
                try {
                    InetSocketAddress isa = new InetSocketAddress(logViewerTcpHost.getHostName(), logViewerTcpHost.getPort());
                    LogViewerTcpConnection logViewerTcpConnection2 = this;
                    synchronized (logViewerTcpConnection2) {
                        this.skt = new Socket();
                        this.skt.setKeepAlive(true);
                        this.skt.connect(isa, 5000);
                        this.sktOs = new BufferedOutputStream(this.skt.getOutputStream());
                    }
                    connected = true;
                }
                catch (Exception e) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void send(byte[] message, int len) {
            while (!this.closed) {
                try {
                    Socket socket = this.skt;
                    synchronized (socket) {
                        this.sktOs.write(message, 0, len);
                    }
                    return;
                }
                catch (Exception e) {
                    LogViewerTcpConnection logViewerTcpConnection = this;
                    synchronized (logViewerTcpConnection) {
                        if (this.skt != null) {
                            try {
                                this.skt.close();
                            }
                            catch (IOException e1) {
                                // empty catch block
                            }
                        }
                    }
                    this.connect();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PredefinedLogViewerConnections {
        CONTROLLER(new LogViewerTcpHost("127.0.0.1", 9975)),
        LOGSERVER(new LogViewerTcpHost("127.0.0.1", 9975));

        LogViewerTcpHost logViewerTcpHost;
        LogViewerTcpConnectionUpdates logViewerTcpConnectionUpdates = null;

        public void setLogViewerTcpConnectionUpdater(LogViewerTcpConnectionUpdates logViewerTcpConnectionUpdates) {
            if (this.logViewerTcpConnectionUpdates != null) {
                this.logViewerTcpConnectionUpdates.removeHost(this.logViewerTcpHost);
            }
            this.logViewerTcpConnectionUpdates = logViewerTcpConnectionUpdates;
        }

        private PredefinedLogViewerConnections(LogViewerTcpHost logViewerTcpHost) {
            this.logViewerTcpHost = logViewerTcpHost;
        }

        public String getHost() {
            return this.logViewerTcpHost.getHostName();
        }

        public void setHost(String host) {
            LogViewerTcpHost prevLogViewerHost = this.logViewerTcpHost;
            this.logViewerTcpHost = new LogViewerTcpHost(host, prevLogViewerHost.getPort());
            if (this.logViewerTcpConnectionUpdates != null) {
                this.logViewerTcpConnectionUpdates.updateHost(prevLogViewerHost, this.logViewerTcpHost);
            }
        }

        public int getPort() {
            return this.logViewerTcpHost.getPort();
        }

        public void setPort(int port) {
            LogViewerTcpHost prevLogViewerHost = this.logViewerTcpHost;
            this.logViewerTcpHost = new LogViewerTcpHost(prevLogViewerHost.getHostName(), port);
            if (this.logViewerTcpConnectionUpdates != null) {
                this.logViewerTcpConnectionUpdates.updateHost(prevLogViewerHost, this.logViewerTcpHost);
            }
        }

        public LogViewerTcpHost getLogViewerTcpHost() {
            return this.logViewerTcpHost;
        }
    }
}

