/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition.impl;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.partition.MigrationCycleOperation;
import com.hazelcast.partition.ReplicaErrorLogger;
import com.hazelcast.partition.impl.InternalPartitionImpl;
import com.hazelcast.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.partition.impl.ReplicaSyncResponse;
import com.hazelcast.partition.impl.ReplicaSyncRetryResponse;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.PartitionReplicationEvent;
import com.hazelcast.spi.ServiceInfo;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public final class ReplicaSyncRequest
extends Operation
implements PartitionAwareOperation,
MigrationCycleOperation {
    public ReplicaSyncRequest() {
    }

    public ReplicaSyncRequest(int partitionId, int replicaIndex) {
        this.setPartitionId(partitionId);
        this.setReplicaIndex(replicaIndex);
    }

    @Override
    public void beforeRun() throws Exception {
        int syncReplicaIndex = this.getReplicaIndex();
        if (syncReplicaIndex < 1 || syncReplicaIndex > 6) {
            throw new IllegalArgumentException("Replica index should be in range [1-6]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)nodeEngine.getPartitionService();
        int partitionId = this.getPartitionId();
        int replicaIndex = this.getReplicaIndex();
        if (!partitionService.isMigrationActive()) {
            ILogger logger = this.getLogger();
            if (logger.isFinestEnabled()) {
                logger.finest("Migration is paused! Cannot run replica sync -> " + this.toString());
            }
            this.sendRetryResponse();
            return;
        }
        if (!this.preCheckReplicaSync(nodeEngine, partitionId, replicaIndex)) {
            return;
        }
        try {
            List<Operation> tasks = this.createReplicationOperations();
            if (tasks.isEmpty()) {
                this.logNoReplicaDataFound(partitionId, replicaIndex);
                this.sendEmptyResponse();
            } else {
                this.sendResponse(tasks);
            }
        }
        finally {
            partitionService.finishReplicaSyncProcess();
        }
    }

    private boolean preCheckReplicaSync(NodeEngineImpl nodeEngine, int partitionId, int replicaIndex) throws IOException {
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)nodeEngine.getPartitionService();
        InternalPartitionImpl partition = partitionService.getPartition(partitionId);
        Address owner = partition.getOwnerOrNull();
        long[] replicaVersions = partitionService.getPartitionReplicaVersions(partitionId);
        long currentVersion = replicaVersions[replicaIndex - 1];
        ILogger logger = this.getLogger();
        if (!nodeEngine.getThisAddress().equals(owner)) {
            if (logger.isFinestEnabled()) {
                logger.finest("Wrong target! " + this.toString() + " cannot be processed! Target should be: " + owner);
            }
            this.sendRetryResponse();
            return false;
        }
        if (currentVersion == 0L) {
            this.sendEmptyResponse();
            return false;
        }
        if (!partitionService.startReplicaSyncProcess()) {
            if (logger.isFinestEnabled()) {
                logger.finest("Max parallel replication process limit exceeded! Could not run replica sync -> " + this.toString());
            }
            this.sendRetryResponse();
            return false;
        }
        return true;
    }

    private void sendRetryResponse() {
        NodeEngine nodeEngine = this.getNodeEngine();
        int partitionId = this.getPartitionId();
        int replicaIndex = this.getReplicaIndex();
        ReplicaSyncRetryResponse response = new ReplicaSyncRetryResponse();
        response.setPartitionId(partitionId).setReplicaIndex(replicaIndex);
        Address target = this.getCallerAddress();
        OperationService operationService = nodeEngine.getOperationService();
        operationService.send(response, target);
    }

    private List<Operation> createReplicationOperations() {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        Collection<ServiceInfo> services = nodeEngine.getServiceInfos(MigrationAwareService.class);
        PartitionReplicationEvent event = new PartitionReplicationEvent(this.getPartitionId(), this.getReplicaIndex());
        LinkedList<Operation> tasks = new LinkedList<Operation>();
        for (ServiceInfo serviceInfo : services) {
            MigrationAwareService service = (MigrationAwareService)serviceInfo.getService();
            Operation op = service.prepareReplicationOperation(event);
            if (op == null) continue;
            op.setServiceName(serviceInfo.getName());
            tasks.add(op);
        }
        return tasks;
    }

    private void sendEmptyResponse() throws IOException {
        this.sendResponse(null);
    }

    private void sendResponse(List<Operation> data) throws IOException {
        NodeEngine nodeEngine = this.getNodeEngine();
        ReplicaSyncResponse syncResponse = this.createResponse(data);
        Address target = this.getCallerAddress();
        ILogger logger = this.getLogger();
        if (logger.isFinestEnabled()) {
            logger.finest("Sending sync response to -> " + target + " for partition: " + this.getPartitionId() + ", replica: " + this.getReplicaIndex());
        }
        OperationService operationService = nodeEngine.getOperationService();
        operationService.send(syncResponse, target);
    }

    private ReplicaSyncResponse createResponse(List<Operation> data) throws IOException {
        int partitionId = this.getPartitionId();
        NodeEngine nodeEngine = this.getNodeEngine();
        InternalPartitionService partitionService = nodeEngine.getPartitionService();
        long[] replicaVersions = partitionService.getPartitionReplicaVersions(partitionId);
        ReplicaSyncResponse syncResponse = new ReplicaSyncResponse(data, replicaVersions);
        syncResponse.setPartitionId(partitionId).setReplicaIndex(this.getReplicaIndex());
        return syncResponse;
    }

    private void logNoReplicaDataFound(int partitionId, int replicaIndex) {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        ILogger logger = nodeEngine.getLogger(this.getClass());
        if (logger.isFinestEnabled()) {
            logger.finest("No replica data is found for partition: " + partitionId + ", replica: " + replicaIndex);
        }
    }

    @Override
    public void afterRun() throws Exception {
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public Object getResponse() {
        return Boolean.TRUE;
    }

    @Override
    public boolean validatesTarget() {
        return false;
    }

    @Override
    public void logError(Throwable e) {
        ReplicaErrorLogger.log(e, this.getLogger());
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ReplicaSyncRequest");
        sb.append("{partition=").append(this.getPartitionId());
        sb.append(", replica=").append(this.getReplicaIndex());
        sb.append('}');
        return sb.toString();
    }
}

