/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.map.impl.RecordStore;
import com.hazelcast.map.impl.operation.AbstractMapOperation;
import com.hazelcast.map.impl.operation.ClearBackupOperation;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionAwareOperation;

public class ClearOperation
extends AbstractMapOperation
implements BackupAwareOperation,
PartitionAwareOperation {
    boolean shouldBackup = true;
    private int numberOfClearedEntries;

    public ClearOperation() {
    }

    public ClearOperation(String name) {
        super(name);
    }

    @Override
    public void run() {
        this.mapService.getMapServiceContext().getNearCacheProvider().clearNearCache(this.name);
        RecordStore recordStore = this.mapService.getMapServiceContext().getExistingRecordStore(this.getPartitionId(), this.name);
        if (recordStore == null) {
            this.shouldBackup = false;
            return;
        }
        this.numberOfClearedEntries = recordStore.clear();
    }

    @Override
    public boolean shouldBackup() {
        return this.shouldBackup;
    }

    @Override
    public int getSyncBackupCount() {
        return this.mapService.getMapServiceContext().getMapContainer(this.name).getBackupCount();
    }

    @Override
    public int getAsyncBackupCount() {
        return this.mapService.getMapServiceContext().getMapContainer(this.name).getAsyncBackupCount();
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    @Override
    public Object getResponse() {
        return this.numberOfClearedEntries;
    }

    @Override
    public Operation getBackupOperation() {
        ClearBackupOperation clearBackupOperation = new ClearBackupOperation(this.name);
        clearBackupOperation.setServiceName("hz:impl:mapService");
        return clearBackupOperation;
    }

    @Override
    public String toString() {
        return "ClearOperation{}";
    }
}

