/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ConnectionType;
import com.hazelcast.nio.tcp.SelectionHandler;
import com.hazelcast.nio.tcp.SocketChannelWrapper;
import com.hazelcast.nio.tcp.TcpIpConnection;
import com.hazelcast.nio.tcp.TcpIpConnectionManager;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.logging.Level;

abstract class AbstractSelectionHandler
implements SelectionHandler {
    protected final ILogger logger;
    protected final SocketChannelWrapper socketChannel;
    protected final TcpIpConnection connection;
    protected final TcpIpConnectionManager connectionManager;
    private SelectionKey sk;

    public AbstractSelectionHandler(TcpIpConnection connection) {
        this.connection = connection;
        this.socketChannel = connection.getSocketChannelWrapper();
        this.connectionManager = connection.getConnectionManager();
        this.logger = this.connectionManager.ioService.getLogger(this.getClass().getName());
    }

    final void handleSocketException(Throwable e) {
        Level level;
        if (e instanceof OutOfMemoryError) {
            this.connectionManager.ioService.onOutOfMemory((OutOfMemoryError)e);
        }
        if (this.sk != null) {
            this.sk.cancel();
        }
        this.connection.close(e);
        ConnectionType connectionType = this.connection.getType();
        if (connectionType.isClient() && !connectionType.isBinary()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Thread.currentThread().getName());
        sb.append(" Closing socket to endpoint ");
        sb.append(this.connection.getEndPoint());
        sb.append(", Cause:").append(e);
        Level level2 = level = this.connectionManager.ioService.isActive() ? Level.WARNING : Level.FINEST;
        if (e instanceof IOException) {
            this.logger.log(level, sb.toString());
        } else {
            this.logger.log(level, sb.toString(), e);
        }
    }

    final void registerOp(Selector selector, int operation) {
        try {
            if (!this.connection.isAlive()) {
                return;
            }
            if (this.sk == null) {
                this.sk = this.socketChannel.keyFor(selector);
            }
            if (this.sk == null) {
                this.sk = this.socketChannel.register(selector, operation, this);
            } else {
                this.sk.interestOps(this.sk.interestOps() | operation);
                if (this.sk.attachment() != this) {
                    this.sk.attach(this);
                }
            }
        }
        catch (Throwable e) {
            this.handleSocketException(e);
        }
    }
}

