/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.concurrent.lock.LockWaitNotifyKey;
import com.hazelcast.core.EntryView;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.map.impl.EntryViews;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.RecordStore;
import com.hazelcast.map.impl.operation.KeyBasedMapOperation;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.DefaultObjectNamespace;
import com.hazelcast.spi.WaitNotifyKey;
import com.hazelcast.spi.WaitSupport;

public class GetEntryViewOperation
extends KeyBasedMapOperation
implements WaitSupport {
    private EntryView<Data, Data> result;

    public GetEntryViewOperation(String name, Data dataKey) {
        super(name, dataKey);
    }

    public GetEntryViewOperation() {
    }

    @Override
    public void run() {
        MapService mapService = (MapService)this.getService();
        RecordStore recordStore = mapService.getMapServiceContext().getRecordStore(this.getPartitionId(), this.name);
        Record record = recordStore.getRecordOrNull(this.dataKey);
        if (record != null) {
            this.result = EntryViews.createSimpleEntryView(record.getKey(), mapService.getMapServiceContext().toData(record.getValue()), record);
        }
    }

    @Override
    public WaitNotifyKey getWaitKey() {
        return new LockWaitNotifyKey(new DefaultObjectNamespace("hz:impl:mapService", this.name), this.dataKey);
    }

    @Override
    public boolean shouldWait() {
        return this.recordStore.isTransactionallyLocked(this.dataKey) && !this.recordStore.canAcquireLock(this.dataKey, this.getCallerUuid(), this.getThreadId());
    }

    @Override
    public void onWaitExpire() {
        this.getResponseHandler().sendResponse(new OperationTimeoutException("Cannot read transactionally locked entry!"));
    }

    @Override
    public Object getResponse() {
        return this.result;
    }

    @Override
    public String toString() {
        return "GetEntryViewOperation{}";
    }
}

