/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.stats;

import java.lang.management.ManagementFactory;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.locks.Lock;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Content;
import org.jitsi.videobridge.RtpChannel;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.stats.OsStatistics;
import org.jitsi.videobridge.stats.Statistics;
import org.jitsi.videobridge.stats.StatsManagerBundleActivator;
import org.osgi.framework.BundleContext;

public class VideobridgeStatistics
extends Statistics {
    public static final String AUDIOCHANNELS = "audiochannels";
    public static final String BITRATE_DOWNLOAD = "bit_rate_download";
    public static final String BITRATE_UPLOAD = "bit_rate_upload";
    public static final String CONFERENCES = "conferences";
    public static final String CPU_USAGE = "cpu_usage";
    private static final DateFormat dateFormat;
    private static final DecimalFormat decimalFormat;
    public static final String NUMBEROFPARTICIPANTS = "participants";
    public static final String NUMBEROFTHREADS = "threads";
    public static final String RTP_LOSS = "rtp_loss";
    public static final String SHUTDOWN_IN_PROGRESS = "graceful_shutdown";
    public static final String TIMESTAMP = "current_timestamp";
    public static final String TOTAL_MEMORY = "total_memory";
    public static final String USED_MEMORY = "used_memory";
    public static final String VIDEOCHANNELS = "videochannels";
    private boolean inGenerate = false;
    private long lastGenerateTime;

    private static double calculateBitRate(long bytes, long period) {
        return (double)bytes * 8.0 / (double)period;
    }

    public static String currentTimeMillis() {
        return dateFormat.format(new Date());
    }

    public VideobridgeStatistics() {
        this.unlockedSetStat(AUDIOCHANNELS, 0);
        this.unlockedSetStat(BITRATE_DOWNLOAD, decimalFormat.format(0.0));
        this.unlockedSetStat(BITRATE_UPLOAD, decimalFormat.format(0.0));
        this.unlockedSetStat(CONFERENCES, 0);
        this.unlockedSetStat(CPU_USAGE, decimalFormat.format(0.0));
        this.unlockedSetStat(NUMBEROFPARTICIPANTS, 0);
        this.unlockedSetStat(NUMBEROFTHREADS, 0);
        this.unlockedSetStat(RTP_LOSS, decimalFormat.format(0.0));
        this.unlockedSetStat(TOTAL_MEMORY, 0);
        this.unlockedSetStat(USED_MEMORY, 0);
        this.unlockedSetStat(VIDEOCHANNELS, 0);
        this.unlockedSetStat(TIMESTAMP, VideobridgeStatistics.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() {
        boolean inGenerate;
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            if (this.inGenerate) {
                inGenerate = true;
            } else {
                inGenerate = false;
                this.inGenerate = true;
            }
            Object var4_3 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
        if (!inGenerate) {
            try {
                this.generate0();
                Object var6_6 = null;
                lock.lock();
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                lock.lock();
                try {
                    this.inGenerate = false;
                    Object var8_10 = null;
                    lock.unlock();
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    lock.unlock();
                    throw throwable2;
                }
                throw throwable;
            }
            try {
                this.inGenerate = false;
                Object var8_8 = null;
                lock.unlock();
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                lock.unlock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generate0() {
        int audioChannels = 0;
        int videoChannels = 0;
        int conferences = 0;
        int endpoints = 0;
        long packets = 0L;
        long packetsLost = 0L;
        long bytesReceived = 0L;
        long bytesSent = 0L;
        boolean shutdownInProgress = false;
        BundleContext bundleContext = StatsManagerBundleActivator.getBundleContext();
        if (bundleContext != null) {
            for (Videobridge videobridge : Videobridge.getVideobridges(bundleContext)) {
                for (Conference conference : videobridge.getConferences()) {
                    for (Content content : conference.getContents()) {
                        MediaType mediaType = content.getMediaType();
                        if (MediaType.AUDIO.equals((Object)mediaType)) {
                            audioChannels += content.getChannelCount();
                        } else if (MediaType.VIDEO.equals((Object)mediaType)) {
                            videoChannels += content.getChannelCount();
                        }
                        for (Channel channel : content.getChannels()) {
                            if (!(channel instanceof RtpChannel)) continue;
                            RtpChannel rtpChannel = (RtpChannel)channel;
                            packets += rtpChannel.getLastPacketsNB();
                            packetsLost += rtpChannel.getLastPacketsLostNB();
                            bytesReceived += rtpChannel.getNBReceivedBytes();
                            bytesSent += rtpChannel.getNBSentBytes();
                        }
                    }
                    ++conferences;
                    endpoints += conference.getEndpointCount();
                }
                if (!videobridge.isShutdownInProgress()) continue;
                shutdownInProgress = true;
            }
        }
        long now = System.currentTimeMillis();
        double rtpLoss = packetsLost > 0L && packets > 0L ? (double)packetsLost / (double)packets : 0.0;
        int threadCount = ManagementFactory.getThreadMXBean().getThreadCount();
        OsStatistics osStatistics = OsStatistics.getOsStatistics();
        double cpuUsage = osStatistics.getCPUUsage();
        int totalMemory = osStatistics.getTotalMemory();
        int usedMemory = osStatistics.getUsedMemory();
        String timestamp = VideobridgeStatistics.currentTimeMillis();
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            long period;
            double bitrateDownload = 0.0;
            double bitrateUpload = 0.0;
            if (this.lastGenerateTime != 0L && (period = now - this.lastGenerateTime) > 0L) {
                bitrateDownload = VideobridgeStatistics.calculateBitRate(bytesReceived, period);
                bitrateUpload = VideobridgeStatistics.calculateBitRate(bytesSent, period);
            }
            this.lastGenerateTime = now;
            this.unlockedSetStat(BITRATE_DOWNLOAD, decimalFormat.format(bitrateDownload));
            this.unlockedSetStat(BITRATE_UPLOAD, decimalFormat.format(bitrateUpload));
            this.unlockedSetStat(RTP_LOSS, decimalFormat.format(rtpLoss));
            this.unlockedSetStat(AUDIOCHANNELS, audioChannels);
            this.unlockedSetStat(CONFERENCES, conferences);
            this.unlockedSetStat(NUMBEROFPARTICIPANTS, endpoints);
            this.unlockedSetStat(VIDEOCHANNELS, videoChannels);
            this.unlockedSetStat(NUMBEROFTHREADS, threadCount);
            this.unlockedSetStat(CPU_USAGE, cpuUsage < 0.0 ? null : decimalFormat.format(cpuUsage));
            this.unlockedSetStat(TOTAL_MEMORY, totalMemory < 0 ? null : Integer.valueOf(totalMemory));
            this.unlockedSetStat(USED_MEMORY, usedMemory < 0 ? null : Integer.valueOf(usedMemory));
            this.unlockedSetStat(SHUTDOWN_IN_PROGRESS, shutdownInProgress);
            this.unlockedSetStat(TIMESTAMP, timestamp);
            Object var34_34 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var34_35 = null;
            lock.unlock();
            throw throwable;
        }
    }

    static {
        decimalFormat = new DecimalFormat("#.#####");
        dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

