/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriConferenceIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.IceUdpTransportPacketExtension;
import org.jitsi.service.neomedia.DtlsControl;
import org.jitsi.service.neomedia.MediaStreamTarget;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.util.Logger;
import org.jitsi.util.StringUtils;
import org.jitsi.util.event.PropertyChangeNotifier;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Content;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.EventFactory;
import org.jitsi.videobridge.IceUdpTransportManager;
import org.jitsi.videobridge.RawUdpTransportManager;
import org.jitsi.videobridge.TransportManager;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.eventadmin.EventAdmin;
import org.osgi.framework.BundleContext;

public abstract class Channel
extends PropertyChangeNotifier {
    public static final int DEFAULT_EXPIRE = 60;
    public static final String INITIATOR_PROPERTY = "initiator";
    private static final Logger logger = Logger.getLogger(Channel.class);
    private final String channelBundleId;
    public static final String ENDPOINT_PROPERTY_NAME = ".endpoint";
    private final Content content;
    private Endpoint endpoint;
    private int expire = 60;
    private boolean expired = false;
    private final String id;
    private boolean initiator = true;
    private long lastActivityTime;
    private StreamConnector streamConnector;
    private TransportManager transportManager;
    private final String transportNamespace;
    private final Object transportManagerSyncRoot = new Object();

    public Channel(Content content, String id, String channelBundleId, String transportNamespace, Boolean initiator) throws Exception {
        if (content == null) {
            throw new NullPointerException("content");
        }
        if (StringUtils.isNullOrEmpty((String)id)) {
            throw new NullPointerException("id");
        }
        this.id = id;
        this.content = content;
        this.channelBundleId = channelBundleId;
        if (initiator != null) {
            this.initiator = initiator;
        }
        if (StringUtils.isNullOrEmpty((String)transportNamespace)) {
            transportNamespace = this.getContent().getConference().getVideobridge().getDefaultTransportManager();
        }
        this.transportNamespace = transportNamespace;
        this.touch();
    }

    protected abstract void closeStream() throws IOException;

    protected StreamConnector createStreamConnector() throws IOException {
        return this.getTransportManager().getStreamConnector(this);
    }

    protected MediaStreamTarget createStreamTarget() {
        try {
            return this.getTransportManager().getStreamTarget(this);
        }
        catch (IOException ioe) {
            return null;
        }
    }

    protected TransportManager createTransportManager(String xmlNamespace) throws IOException {
        if ("urn:xmpp:jingle:transports:ice-udp:1".equals(xmlNamespace)) {
            Content content = this.getContent();
            return new IceUdpTransportManager(content.getConference(), this.isInitiator(), 2, content.getName());
        }
        if ("urn:xmpp:jingle:transports:raw-udp:1".equals(xmlNamespace)) {
            return new RawUdpTransportManager(this);
        }
        throw new IllegalArgumentException("Unsupported Jingle transport " + xmlNamespace);
    }

    public void describe(ColibriConferenceIQ.ChannelCommon iq) {
        Endpoint endpoint = this.getEndpoint();
        if (endpoint != null) {
            iq.setEndpoint(endpoint.getID());
        }
        iq.setID(this.id);
        iq.setExpire(this.getExpire());
        iq.setInitiator(Boolean.valueOf(this.isInitiator()));
        if (this.channelBundleId != null) {
            iq.setChannelBundleId(this.channelBundleId);
        } else {
            this.describeTransportManager(iq);
        }
    }

    private void describeTransportManager(ColibriConferenceIQ.ChannelCommon iq) {
        TransportManager transportManager;
        try {
            transportManager = this.getTransportManager();
        }
        catch (IOException ioe) {
            throw new UndeclaredThrowableException(ioe);
        }
        transportManager.describe(iq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire() {
        Conference conference;
        Content content;
        block27: {
            Object t22;
            block26: {
                block25: {
                    Channel channel = this;
                    synchronized (channel) {
                        if (this.expired) {
                            return;
                        }
                        this.expired = true;
                    }
                    content = this.getContent();
                    conference = content.getConference();
                    EventAdmin eventAdmin = conference.getVideobridge().getEventAdmin();
                    if (eventAdmin != null) {
                        eventAdmin.sendEvent(EventFactory.channelExpired(this));
                    }
                    try {
                        content.expireChannel(this);
                        Object var5_5 = null;
                    }
                    catch (Throwable throwable) {
                        block30: {
                            Object t22;
                            block29: {
                                block28: {
                                    Object var5_6 = null;
                                    try {
                                        this.closeStream();
                                    }
                                    catch (Throwable t22) {
                                        logger.warn((Object)("Failed to close the MediaStream/stream of channel " + this.getID() + " of content " + content.getName() + " of conference " + conference.getID() + "!"), (Throwable)t22);
                                        if (!(t22 instanceof ThreadDeath)) break block28;
                                        throw (ThreadDeath)t22;
                                    }
                                }
                                try {
                                    t22 = this.transportManagerSyncRoot;
                                    synchronized (t22) {
                                        if (this.transportManager != null) {
                                            this.transportManager.close(this);
                                        }
                                    }
                                }
                                catch (Throwable t22) {
                                    logger.warn((Object)("Failed to close the TransportManager/transportManager of channel " + this.getID() + " of content " + content.getName() + " of conference " + conference.getID() + "!"), (Throwable)t22);
                                    if (!(t22 instanceof ThreadDeath)) break block29;
                                    throw (ThreadDeath)t22;
                                }
                            }
                            try {
                                this.onEndpointChanged(this.getEndpoint(), null);
                            }
                            catch (Throwable t22) {
                                if (!(t22 instanceof ThreadDeath)) break block30;
                                throw (ThreadDeath)t22;
                            }
                        }
                        Videobridge videobridge = conference.getVideobridge();
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)("Expired channel " + this.getID() + " of content " + content.getName() + " of conference " + conference.getID() + ". The total number of conferences is now " + videobridge.getConferenceCount() + ", channels " + videobridge.getChannelCount() + "."));
                        }
                        throw throwable;
                    }
                    try {
                        this.closeStream();
                    }
                    catch (Throwable t22) {
                        logger.warn((Object)("Failed to close the MediaStream/stream of channel " + this.getID() + " of content " + content.getName() + " of conference " + conference.getID() + "!"), (Throwable)t22);
                        if (!(t22 instanceof ThreadDeath)) break block25;
                        throw (ThreadDeath)t22;
                    }
                }
                try {
                    t22 = this.transportManagerSyncRoot;
                    synchronized (t22) {
                        if (this.transportManager != null) {
                            this.transportManager.close(this);
                        }
                    }
                }
                catch (Throwable t22) {
                    logger.warn((Object)("Failed to close the TransportManager/transportManager of channel " + this.getID() + " of content " + content.getName() + " of conference " + conference.getID() + "!"), (Throwable)t22);
                    if (!(t22 instanceof ThreadDeath)) break block26;
                    throw (ThreadDeath)t22;
                }
            }
            try {
                this.onEndpointChanged(this.getEndpoint(), null);
            }
            catch (Throwable t22) {
                if (!(t22 instanceof ThreadDeath)) break block27;
                throw (ThreadDeath)t22;
            }
        }
        Videobridge videobridge = conference.getVideobridge();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Expired channel " + this.getID() + " of content " + content.getName() + " of conference " + conference.getID() + ". The total number of conferences is now " + videobridge.getConferenceCount() + ", channels " + videobridge.getChannelCount() + "."));
        }
    }

    public BundleContext getBundleContext() {
        return this.getContent().getBundleContext();
    }

    public final Content getContent() {
        return this.content;
    }

    protected DtlsControl getDtlsControl() throws IOException {
        return this.getTransportManager().getDtlsControl(this);
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public int getExpire() {
        return this.expire;
    }

    public final String getID() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastActivityTime() {
        Channel channel = this;
        synchronized (channel) {
            return this.lastActivityTime;
        }
    }

    StreamConnector getStreamConnector() throws IOException {
        if (this.streamConnector == null) {
            this.streamConnector = this.createStreamConnector();
        }
        return this.streamConnector;
    }

    public TransportManager getTransportManager() throws IOException {
        return this.transportManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws IOException {
        Object object = this.transportManagerSyncRoot;
        synchronized (object) {
            this.transportManager = this.channelBundleId == null ? this.createTransportManager(this.transportNamespace) : this.getContent().getConference().getTransportManager(this.channelBundleId, true);
            if (this.transportManager == null) {
                throw new IOException("Failed to get transport manager.");
            }
            this.transportManager.addChannel(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExpired() {
        Channel channel = this;
        synchronized (channel) {
            return this.expired;
        }
    }

    public boolean isInitiator() {
        return this.initiator;
    }

    protected abstract void maybeStartStream() throws IOException;

    protected void onEndpointChanged(Endpoint oldValue, Endpoint newValue) {
        this.firePropertyChange(ENDPOINT_PROPERTY_NAME, oldValue, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setEndpoint(String endpoint) {
        block8: {
            block7: {
                try {
                    Endpoint newValue;
                    Endpoint oldValue = this.endpoint;
                    if (oldValue == null) {
                        if (endpoint == null) {
                            Object var5_3 = null;
                            this.touch();
                            return;
                        }
                    } else if (oldValue.getID().equals(endpoint)) {
                        break block7;
                    }
                    if (oldValue != (newValue = this.getContent().getConference().getOrCreateEndpoint(endpoint))) {
                        this.endpoint = newValue;
                        this.onEndpointChanged(oldValue, newValue);
                    }
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    this.touch();
                    throw throwable;
                }
            }
            Object var5_4 = null;
            this.touch();
            return;
        }
        Object var5_5 = null;
        this.touch();
    }

    public void setExpire(int expire) {
        if (expire < 0) {
            throw new IllegalArgumentException("expire");
        }
        this.expire = expire;
        if (this.expire == 0) {
            this.expire();
        } else {
            this.touch();
        }
    }

    public void setInitiator(boolean initiator) {
        boolean oldValue = this.initiator;
        boolean newValue = this.initiator = initiator;
        this.touch();
        if (oldValue != newValue) {
            this.firePropertyChange(INITIATOR_PROPERTY, oldValue, newValue);
        }
    }

    public void setTransport(IceUdpTransportPacketExtension transport) throws IOException {
        if (transport != null) {
            this.getTransportManager().startConnectivityEstablishment(transport);
        }
        this.touch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touch() {
        long now = System.currentTimeMillis();
        Channel channel = this;
        synchronized (channel) {
            if (this.getLastActivityTime() < now) {
                this.lastActivityTime = now;
            }
        }
    }

    void transportClosed() {
        this.expire();
    }

    void transportConnected() {
        logger.info((Object)("Transport connected for channel " + this.getID() + " of content " + this.getContent().getName() + " of conference " + this.getContent().getConference().getID()));
        try {
            this.maybeStartStream();
        }
        catch (IOException ioe) {
            logger.warn((Object)("Failed to start stream for channel: " + this.getID() + ": " + ioe));
        }
    }
}

