/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio;

import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;
import org.jitsi.impl.neomedia.codec.FFmpeg;

public abstract class AbstractFFmpegAudioCodec
extends AbstractCodec2 {
    protected long avctx;
    protected final int codecID;
    protected int frameSizeInBytes;

    public static String codecIDToString(int codecID) {
        switch (codecID) {
            case 86017: {
                return "CODEC_ID_MP3";
            }
        }
        return "0x" + Long.toHexString((long)codecID & 0xFFFFFFFFL);
    }

    protected AbstractFFmpegAudioCodec(String name, int codecID, Format[] supportedOutputFormats) {
        super(name, AudioFormat.class, supportedOutputFormats);
        this.codecID = codecID;
    }

    protected void configureAVCodecContext(long avctx, AudioFormat format) {
    }

    @Override
    protected synchronized void doClose() {
        if (this.avctx != 0L) {
            FFmpeg.avcodec_close(this.avctx);
            FFmpeg.av_free(this.avctx);
            this.avctx = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void doOpen() throws ResourceUnavailableException {
        int codecID = this.codecID;
        long codec = this.findAVCodec(codecID);
        if (codec == 0L) {
            throw new ResourceUnavailableException("Could not find FFmpeg codec " + AbstractFFmpegAudioCodec.codecIDToString(codecID) + "!");
        }
        this.avctx = FFmpeg.avcodec_alloc_context3(codec);
        if (this.avctx == 0L) {
            throw new ResourceUnavailableException("Could not allocate AVCodecContext for FFmpeg codec " + AbstractFFmpegAudioCodec.codecIDToString(codecID) + "!");
        }
        int avcodec_open = -1;
        try {
            AudioFormat format = this.getAVCodecContextFormat();
            int channels = format.getChannels();
            int sampleRate = (int)format.getSampleRate();
            if (channels == -1) {
                channels = 1;
            }
            FFmpeg.avcodeccontext_set_channels(this.avctx, channels);
            if (sampleRate != -1) {
                FFmpeg.avcodeccontext_set_sample_rate(this.avctx, sampleRate);
            }
            this.configureAVCodecContext(this.avctx, format);
            avcodec_open = FFmpeg.avcodec_open2(this.avctx, codec, new String[0]);
            int frameSize = FFmpeg.avcodeccontext_get_frame_size(this.avctx);
            this.frameSizeInBytes = frameSize * (format.getSampleSizeInBits() / 8) * channels;
        }
        finally {
            if (avcodec_open < 0) {
                FFmpeg.av_free(this.avctx);
                this.avctx = 0L;
            }
        }
        if (this.avctx == 0L) {
            throw new ResourceUnavailableException("Could not open FFmpeg codec " + AbstractFFmpegAudioCodec.codecIDToString(codecID) + "!");
        }
    }

    protected abstract long findAVCodec(int var1);

    protected abstract AudioFormat getAVCodecContextFormat();
}

