/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr.convert;

import java.lang.reflect.Method;
import uk.ltd.getahead.dwr.ConversionException;
import uk.ltd.getahead.dwr.Converter;
import uk.ltd.getahead.dwr.ConverterManager;
import uk.ltd.getahead.dwr.InboundContext;
import uk.ltd.getahead.dwr.InboundVariable;
import uk.ltd.getahead.dwr.Messages;
import uk.ltd.getahead.dwr.OutboundContext;
import uk.ltd.getahead.dwr.compat.BaseV10Converter;
import uk.ltd.getahead.dwr.util.LocalUtil;

public class EnumConverter
extends BaseV10Converter
implements Converter {
    public void setConverterManager(ConverterManager config) {
    }

    public Object convertInbound(Class paramType, InboundVariable iv, InboundContext inctx) throws ConversionException {
        String value = LocalUtil.decode(iv.getValue());
        Object[] values = null;
        try {
            Method getter = paramType.getMethod("values", new Class[0]);
            values = (Object[])getter.invoke((Object)paramType, null);
        }
        catch (NoSuchMethodException ex) {
            throw new ConversionException(Messages.getString("EnumConverter.TypeNotEnum", paramType));
        }
        catch (Exception ex) {
            throw new ConversionException(Messages.getString("EnumConverter.ReflectionError", paramType), ex);
        }
        int i = 0;
        while (i < values.length) {
            Object en = values[i];
            if (value.equals(en.toString())) {
                return en;
            }
            ++i;
        }
        throw new ConversionException(Messages.getString("EnumConverter.NoMatch", value, paramType));
    }

    public String convertOutbound(Object object, String varname, OutboundContext outctx) {
        return "var " + varname + "='" + object.toString() + "';";
    }
}

