/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.stunclient;

import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.StunException;
import org.ice4j.StunMessageEvent;
import org.ice4j.TransportAddress;
import org.ice4j.message.Response;
import org.ice4j.socket.IceSocketWrapper;
import org.ice4j.socket.IceUdpSocketWrapper;
import org.ice4j.socket.SafeCloseDatagramSocket;
import org.ice4j.stack.RequestListener;
import org.ice4j.stack.StunStack;

public class ResponseSequenceServer
implements RequestListener {
    private static final Logger logger = Logger.getLogger(ResponseSequenceServer.class.getName());
    private Vector<Object> messageSequence = new Vector();
    private final StunStack stunStack;
    private TransportAddress serverAddress = null;
    private IceSocketWrapper localSocket = null;

    public ResponseSequenceServer(StunStack stunStack, TransportAddress bindAddress) {
        this.stunStack = stunStack;
        this.serverAddress = bindAddress;
    }

    public void start() throws IOException, StunException {
        this.localSocket = new IceUdpSocketWrapper(new SafeCloseDatagramSocket(this.serverAddress));
        this.stunStack.addSocket(this.localSocket);
        this.stunStack.addRequestListener(this.serverAddress, this);
    }

    public void shutDown() {
        this.stunStack.removeSocket(this.serverAddress);
        this.messageSequence.removeAllElements();
        this.localSocket.close();
    }

    public void addMessage(Response response) {
        if (response == null) {
            this.messageSequence.add(new Boolean(false));
        } else {
            this.messageSequence.add(response);
        }
    }

    public void processRequest(StunMessageEvent evt) {
        if (this.messageSequence.isEmpty()) {
            return;
        }
        Object obj = this.messageSequence.remove(0);
        if (!(obj instanceof Response)) {
            return;
        }
        Response res = (Response)obj;
        try {
            this.stunStack.sendResponse(evt.getMessage().getTransactionID(), res, this.serverAddress, evt.getRemoteAddress());
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "failed to send a response", ex);
        }
    }

    public String toString() {
        return this.serverAddress == null ? "null" : this.serverAddress.toString();
    }
}

