/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.util;

import java.util.Hashtable;
import java.util.Map;
import net.java.sip.communicator.service.gui.AlertUIService;
import net.java.sip.communicator.service.gui.UIService;
import net.java.sip.communicator.service.protocol.AccountManager;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.resources.ResourceManagementServiceUtils;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.fileaccess.FileAccessService;
import org.jitsi.service.neomedia.MediaConfigurationService;
import org.jitsi.service.neomedia.MediaService;
import org.jitsi.service.resources.ResourceManagementService;
import org.jitsi.util.OSUtils;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class UtilActivator
implements BundleActivator,
Thread.UncaughtExceptionHandler {
    private static final Logger logger = Logger.getLogger(UtilActivator.class);
    private static ConfigurationService configurationService;
    private static ResourceManagementService resourceService;
    private static UIService uiService;
    private static FileAccessService fileAccessService;
    private static MediaService mediaService;
    public static BundleContext bundleContext;
    private static AccountManager accountManager;
    private static AlertUIService alertUIService;

    public void start(BundleContext context) throws Exception {
        bundleContext = context;
        if (OSUtils.IS_ANDROID) {
            this.loadLoggingConfig();
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Setting default uncaught exception handler.");
        }
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    private void loadLoggingConfig() {
        try {
            Class.forName("net.java.sip.communicator.util.JavaUtilLoggingConfig").newInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void uncaughtException(Thread thread, Throwable exc) {
        logger.error("An uncaught exception occurred in thread=" + thread + " and message was: " + exc.getMessage(), exc);
    }

    public void stop(BundleContext context) throws Exception {
    }

    public static ConfigurationService getConfigurationService() {
        if (configurationService == null) {
            configurationService = ServiceUtils.getService(bundleContext, ConfigurationService.class);
        }
        return configurationService;
    }

    public static ResourceManagementService getResources() {
        if (resourceService == null) {
            resourceService = ResourceManagementServiceUtils.getService((BundleContext)bundleContext);
        }
        return resourceService;
    }

    public static UIService getUIService() {
        if (uiService == null) {
            uiService = ServiceUtils.getService(bundleContext, UIService.class);
        }
        return uiService;
    }

    public static FileAccessService getFileAccessService() {
        if (fileAccessService == null) {
            fileAccessService = ServiceUtils.getService(bundleContext, FileAccessService.class);
        }
        return fileAccessService;
    }

    public static MediaService getMediaService() {
        if (mediaService == null) {
            mediaService = ServiceUtils.getService(bundleContext, MediaService.class);
        }
        return mediaService;
    }

    public static MediaConfigurationService getMediaConfiguration() {
        return ServiceUtils.getService(bundleContext, MediaConfigurationService.class);
    }

    public static Map<Object, ProtocolProviderFactory> getProtocolProviderFactories() {
        Hashtable<Object, ProtocolProviderFactory> providerFactoriesMap = new Hashtable<Object, ProtocolProviderFactory>();
        ServiceReference[] serRefs = null;
        try {
            serRefs = bundleContext.getServiceReferences(ProtocolProviderFactory.class.getName(), null);
        }
        catch (InvalidSyntaxException e) {
            logger.error("LoginManager : " + (Object)((Object)e));
        }
        if (serRefs != null) {
            for (ServiceReference serRef : serRefs) {
                ProtocolProviderFactory providerFactory = (ProtocolProviderFactory)bundleContext.getService(serRef);
                providerFactoriesMap.put(serRef.getProperty("PROTOCOL_NAME"), providerFactory);
            }
        }
        return providerFactoriesMap;
    }

    public static AccountManager getAccountManager() {
        if (accountManager == null) {
            accountManager = ServiceUtils.getService(bundleContext, AccountManager.class);
        }
        return accountManager;
    }

    public static AlertUIService getAlertUIService() {
        if (alertUIService == null) {
            alertUIService = ServiceUtils.getService(bundleContext, AlertUIService.class);
        }
        return alertUIService;
    }
}

