/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.ajp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpServer;
import org.mortbay.http.ajp.AJP13Connection;
import org.mortbay.log.LogFactory;
import org.mortbay.util.InetAddrPort;
import org.mortbay.util.ThreadedServer;

public class AJP13Listener
extends ThreadedServer
implements HttpListener {
    private static Log log = LogFactory.getLog(class$org$mortbay$http$ajp$AJP13Listener == null ? (class$org$mortbay$http$ajp$AJP13Listener = AJP13Listener.class$("org.mortbay.http.ajp.AJP13Listener")) : class$org$mortbay$http$ajp$AJP13Listener);
    private HttpServer _server;
    private boolean _lastOut = false;
    private boolean _lastLow = false;
    private String _integralScheme = "https";
    private String _confidentialScheme = "https";
    private int _integralPort = 0;
    private int _confidentialPort = 0;
    private boolean _identifyListener = false;
    private int _bufferSize = 8192;
    private int _bufferReserve = 512;
    private String[] _remoteServers;
    private HttpHandler _handler;
    static /* synthetic */ Class class$org$mortbay$http$ajp$AJP13Listener;

    public AJP13Listener() {
    }

    public AJP13Listener(InetAddrPort address) {
        super(address);
    }

    public void setHttpServer(HttpServer server) {
        this._server = server;
    }

    public HttpServer getHttpServer() {
        return this._server;
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public void setBufferSize(int size) {
        this._bufferSize = size;
        if (this._bufferSize > 8192) {
            log.warn((Object)("AJP Data buffer > 8192: " + size));
        }
    }

    public int getBufferReserve() {
        return this._bufferReserve;
    }

    public void setBufferReserve(int size) {
        this._bufferReserve = size;
    }

    public boolean getIdentifyListener() {
        return this._identifyListener;
    }

    public void setIdentifyListener(boolean identifyListener) {
        this._identifyListener = identifyListener;
    }

    public String getDefaultScheme() {
        return "http";
    }

    public void start() throws Exception {
        super.start();
        log.info((Object)("Started AJP13Listener on " + this.getInetAddrPort()));
        log.info((Object)("NOTICE: AJP13 is not a secure protocol. Please protect the port " + this.getInetAddrPort()));
    }

    public void stop() throws InterruptedException {
        super.stop();
        log.info((Object)("Stopped AJP13Listener on " + this.getInetAddrPort()));
    }

    public String[] getRemoteServers() {
        return this._remoteServers;
    }

    public void setRemoteServers(String[] servers) {
        this._remoteServers = servers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleConnection(Socket socket) throws IOException {
        if (this._remoteServers != null && this._remoteServers.length > 0) {
            boolean match = false;
            InetAddress inetAddress = socket.getInetAddress();
            String hostAddr = inetAddress.getHostAddress();
            String hostName = inetAddress.getHostName();
            for (int i = 0; i < this._remoteServers.length; ++i) {
                if (!hostName.equals(this._remoteServers[i]) && !hostAddr.equals(this._remoteServers[i])) continue;
                match = true;
                break;
            }
            if (!match) {
                log.warn((Object)("AJP13 Connection from un-approved host: " + inetAddress));
                return;
            }
        }
        socket.setTcpNoDelay(true);
        socket.setSoTimeout(this.getMaxIdleTimeMs());
        AJP13Connection connection = this.createConnection(socket);
        try {
            connection.handle();
        }
        finally {
            connection.destroy();
        }
    }

    protected AJP13Connection createConnection(Socket socket) throws IOException {
        return new AJP13Connection(this, socket.getInputStream(), socket.getOutputStream(), socket, this.getBufferSize());
    }

    public void customizeRequest(HttpConnection connection, HttpRequest request) {
        if (this._identifyListener) {
            request.setAttribute("org.mortbay.http.HttpListener", this.getName());
        }
        Socket socket = (Socket)connection.getConnection();
        this.customizeRequest(socket, request);
    }

    protected void customizeRequest(Socket socket, HttpRequest request) {
    }

    public void persistConnection(HttpConnection connection) {
    }

    public boolean isLowOnResources() {
        boolean low;
        boolean bl = low = this.getThreads() == this.getMaxThreads() && this.getIdleThreads() < this.getMinThreads();
        if (low && !this._lastLow) {
            log.info((Object)("LOW ON THREADS: " + this));
        } else if (!low && this._lastLow) {
            log.info((Object)("OK on threads: " + this));
            this._lastOut = false;
        }
        this._lastLow = low;
        return low;
    }

    public boolean isOutOfResources() {
        boolean out;
        boolean bl = out = this.getThreads() == this.getMaxThreads() && this.getIdleThreads() == 0;
        if (out && !this._lastOut) {
            log.warn((Object)("OUT OF THREADS: " + this));
        }
        this._lastOut = out;
        return out;
    }

    public boolean isIntegral(HttpConnection connection) {
        return ((AJP13Connection)connection).isSSL();
    }

    public boolean isConfidential(HttpConnection connection) {
        return ((AJP13Connection)connection).isSSL();
    }

    public String getIntegralScheme() {
        return this._integralScheme;
    }

    public void setIntegralScheme(String integralScheme) {
        this._integralScheme = integralScheme;
    }

    public int getIntegralPort() {
        return this._integralPort;
    }

    public void setIntegralPort(int integralPort) {
        this._integralPort = integralPort;
    }

    public String getConfidentialScheme() {
        return this._confidentialScheme;
    }

    public void setConfidentialScheme(String confidentialScheme) {
        this._confidentialScheme = confidentialScheme;
    }

    public int getConfidentialPort() {
        return this._confidentialPort;
    }

    public void setConfidentialPort(int confidentialPort) {
        this._confidentialPort = confidentialPort;
    }

    public HttpHandler getHttpHandler() {
        return this._handler;
    }

    public void setHttpHandler(HttpHandler handler) {
        this._handler = handler;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

