/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icon;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.ExtraInfoBlock;
import net.kano.joscar.snaccmd.icon.IconCommand;

public class UploadIconAck
extends IconCommand {
    public static final int CODE_DEFAULT = 0;
    private final int code;
    private final ExtraInfoBlock iconInfo;

    protected UploadIconAck(SnacPacket snacPacket) {
        super(3);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        this.code = BinaryTools.getUByte(byteBlock, 0);
        ByteBlock byteBlock2 = byteBlock.subBlock(1);
        this.iconInfo = ExtraInfoBlock.readExtraInfoBlock(byteBlock2);
    }

    public UploadIconAck(ExtraInfoBlock extraInfoBlock) {
        this(0, extraInfoBlock);
    }

    public UploadIconAck(int n, ExtraInfoBlock extraInfoBlock) {
        super(3);
        DefensiveTools.checkRange(n, "code", 0);
        this.code = n;
        this.iconInfo = extraInfoBlock;
    }

    public final int getCode() {
        return this.code;
    }

    public final ExtraInfoBlock getIconInfo() {
        return this.iconInfo;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        BinaryTools.writeUByte(outputStream, this.code);
        if (this.iconInfo != null) {
            this.iconInfo.write(outputStream);
        }
    }

    public String toString() {
        return "UploadIconAck: code=" + this.code + ", iconInfo=<" + this.iconInfo + ">";
    }
}

