/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd.sendbl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.LinkedList;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.StringBlock;

public class SendBuddyListGroup
implements LiveWritable {
    private final String groupName;
    private final String[] buddies;
    private final int totalSize;

    public static SendBuddyListGroup[] readBuddyListGroups(ByteBlock byteBlock) {
        SendBuddyListGroup sendBuddyListGroup;
        DefensiveTools.checkNull(byteBlock, "block");
        LinkedList<SendBuddyListGroup> linkedList = new LinkedList<SendBuddyListGroup>();
        while ((sendBuddyListGroup = SendBuddyListGroup.readBuddyListGroup(byteBlock)) != null) {
            linkedList.add(sendBuddyListGroup);
            byteBlock = byteBlock.subBlock(sendBuddyListGroup.getTotalSize());
        }
        return linkedList.toArray(new SendBuddyListGroup[0]);
    }

    public static SendBuddyListGroup readBuddyListGroup(ByteBlock byteBlock) {
        DefensiveTools.checkNull(byteBlock, "block");
        StringBlock stringBlock = SendBuddyListGroup.readString(byteBlock);
        if (stringBlock == null || byteBlock.getLength() < stringBlock.getTotalSize() + 2) {
            return null;
        }
        int n = BinaryTools.getUShort(byteBlock, stringBlock.getTotalSize());
        String[] stringArray = new String[n];
        ByteBlock byteBlock2 = byteBlock.subBlock(stringBlock.getTotalSize() + 2);
        int n2 = stringBlock.getTotalSize() + 2;
        for (int i = 0; i < stringArray.length; ++i) {
            StringBlock stringBlock2 = SendBuddyListGroup.readString(byteBlock2);
            if (stringBlock2 == null) {
                return null;
            }
            stringArray[i] = stringBlock2.getString();
            byteBlock2 = byteBlock2.subBlock(stringBlock2.getTotalSize());
            n2 += stringBlock2.getTotalSize();
        }
        return new SendBuddyListGroup(stringBlock.getString(), stringArray, n2);
    }

    private static final StringBlock readString(ByteBlock byteBlock) {
        DefensiveTools.checkNull(byteBlock, "block");
        if (byteBlock.getLength() < 2) {
            return null;
        }
        int n = BinaryTools.getUShort(byteBlock, 0);
        if (byteBlock.getLength() < n + 2) {
            return null;
        }
        String string = BinaryTools.getAsciiString(byteBlock.subBlock(2, n));
        return new StringBlock(string, 2 + n);
    }

    private static final void writeString(OutputStream outputStream, String string) throws IOException {
        DefensiveTools.checkNull(outputStream, "out");
        DefensiveTools.checkNull(string, "str");
        byte[] byArray = BinaryTools.getAsciiBytes(string);
        BinaryTools.writeUShort(outputStream, byArray.length);
        outputStream.write(byArray);
    }

    private SendBuddyListGroup(String string, String[] stringArray, int n) {
        DefensiveTools.checkNull(string, "groupName");
        DefensiveTools.checkNull(stringArray, "buddies");
        DefensiveTools.checkRange(n, "totalSize", -1);
        this.groupName = string;
        this.buddies = (String[])stringArray.clone();
        this.totalSize = n;
        DefensiveTools.checkNullElements(this.buddies, "buddies");
    }

    public SendBuddyListGroup(String string, String[] stringArray) {
        this(string, stringArray, -1);
    }

    public final String getGroupName() {
        return this.groupName;
    }

    public final String[] getBuddies() {
        return (String[])this.buddies.clone();
    }

    public final int getTotalSize() {
        return this.totalSize;
    }

    public void write(OutputStream outputStream) throws IOException {
        SendBuddyListGroup.writeString(outputStream, this.groupName);
        BinaryTools.writeUShort(outputStream, this.buddies.length);
        for (int i = 0; i < this.buddies.length; ++i) {
            SendBuddyListGroup.writeString(outputStream, this.buddies[i]);
        }
    }

    public String toString() {
        return "SendBuddyListGroup for group '" + this.groupName + "': " + Arrays.asList(this.buddies);
    }
}

