/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import uk.ltd.getahead.dwr.Container;
import uk.ltd.getahead.dwr.WebContext;
import uk.ltd.getahead.dwr.util.SwallowingHttpServletResponse;

public class DefaultWebContext
implements WebContext {
    private HttpServletRequest request = null;
    private HttpServletResponse response = null;
    private ServletConfig config = null;
    private ServletContext context = null;
    private Container container;
    private static final String FILENAME_VERSION = "/dwr-version.properties";
    private static final String KEY_VERSION = "version";
    private static final String KEY_SCCINFO = "scc-info";
    private static final String KEY_ERROR = "error";
    private static final String VALUE_UNKNOWN = "unknown";
    private static Properties props = null;
    private static final Object propLock = new Object();

    public DefaultWebContext(HttpServletRequest request, HttpServletResponse response, ServletConfig config, ServletContext context, Container container) {
        this.request = request;
        this.response = response;
        this.config = config;
        this.context = context;
        this.container = container;
    }

    public Container getContainer() {
        return this.container;
    }

    public HttpSession getSession() {
        return this.request.getSession();
    }

    public HttpSession getSession(boolean create) {
        return this.request.getSession(create);
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.request;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.response;
    }

    public String forwardToString(String url) throws ServletException, IOException {
        StringWriter sout = new StringWriter();
        StringBuffer buffer = sout.getBuffer();
        SwallowingHttpServletResponse fakeResponse = new SwallowingHttpServletResponse(this.response, sout, this.response.getCharacterEncoding());
        this.getServletContext().getRequestDispatcher(url).forward((ServletRequest)this.getHttpServletRequest(), (ServletResponse)fakeResponse);
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVersion() {
        Object object = propLock;
        synchronized (object) {
            if (props == null) {
                this.loadProperties();
            }
            return props.getProperty(KEY_VERSION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSourceControlInfo() {
        Object object = propLock;
        synchronized (object) {
            if (props == null) {
                this.loadProperties();
            }
            return props.getProperty(KEY_SCCINFO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties() {
        Object object = propLock;
        synchronized (object) {
            props = new Properties();
            try {
                InputStream in = this.getClass().getResourceAsStream(FILENAME_VERSION);
                props.load(in);
            }
            catch (Exception ex) {
                props.put(KEY_VERSION, VALUE_UNKNOWN);
                props.put(KEY_SCCINFO, VALUE_UNKNOWN);
                props.put(KEY_ERROR, ex.toString());
            }
        }
    }
}

