/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.message;

import gov.nist.core.GenericObject;
import gov.nist.core.GenericObjectList;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public abstract class MessageObject
extends GenericObject {
    protected static final String MESSAGE_PACKAGE = "gov.nist.javax.sip.message";
    protected static final String SIP_PACKAGE = "gov.nist.javax.sip";
    protected static final String PARSER_PACKAGE = "gov.nist.javax.sip.parser";
    protected static final String SIPHEADERS_PACKAGE = "gov.nist.javax.sip.header";

    public abstract String encode();

    public void dbgPrint() {
        super.dbgPrint();
    }

    public String debugDump() {
        this.stringRepresentation = "";
        Class<?> myclass = this.getClass();
        this.sprint(myclass.getName());
        this.sprint("{");
        Field[] fields = myclass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            int modifier = f.getModifiers();
            if (modifier == 2) continue;
            Class<?> fieldType = f.getType();
            String fieldName = f.getName();
            if (fieldName.compareTo("stringRepresentation") == 0 || fieldName.compareTo("indentation") == 0) continue;
            this.sprint(fieldName + ":");
            try {
                if (fieldType.isPrimitive()) {
                    String fname = fieldType.toString();
                    this.sprint(fname + ":");
                    if (fname.compareTo("int") == 0) {
                        int intfield = f.getInt(this);
                        this.sprint(intfield);
                        continue;
                    }
                    if (fname.compareTo("short") == 0) {
                        short shortField = f.getShort(this);
                        this.sprint(shortField);
                        continue;
                    }
                    if (fname.compareTo("char") == 0) {
                        char charField = f.getChar(this);
                        this.sprint(charField);
                        continue;
                    }
                    if (fname.compareTo("long") == 0) {
                        long longField = f.getLong(this);
                        this.sprint(longField);
                        continue;
                    }
                    if (fname.compareTo("boolean") == 0) {
                        boolean booleanField = f.getBoolean(this);
                        this.sprint(booleanField);
                        continue;
                    }
                    if (fname.compareTo("double") == 0) {
                        double doubleField = f.getDouble(this);
                        this.sprint(doubleField);
                        continue;
                    }
                    if (fname.compareTo("float") != 0) continue;
                    float floatField = f.getFloat(this);
                    this.sprint(floatField);
                    continue;
                }
                if (MessageObject.getClassFromName("gov.nist.javax.sip.GenericObject").isAssignableFrom(fieldType)) {
                    if (f.get(this) != null) {
                        this.sprint(((GenericObject)f.get(this)).debugDump(this.indentation + 1));
                        continue;
                    }
                    this.sprint("<null>");
                    continue;
                }
                if (MessageObject.getClassFromName("gov.nist.javax.sip.GenericObjectList").isAssignableFrom(fieldType)) {
                    if (f.get(this) != null) {
                        this.sprint(((GenericObjectList)f.get(this)).debugDump(this.indentation + 1));
                        continue;
                    }
                    this.sprint("<null>");
                    continue;
                }
                if (f.get(this) != null) {
                    this.sprint(f.get(this).getClass().getName() + ":");
                } else {
                    this.sprint(fieldType.getName() + ":");
                }
                this.sprint("{");
                if (f.get(this) != null) {
                    this.sprint(f.get(this).toString());
                } else {
                    this.sprint("<null>");
                }
                this.sprint("}");
                continue;
            }
            catch (IllegalAccessException ex1) {
                // empty catch block
            }
        }
        this.sprint("}");
        return this.stringRepresentation;
    }

    public void merge(Object mergeObject) {
        if (!mergeObject.getClass().equals(this.getClass())) {
            throw new IllegalArgumentException("Bad override object");
        }
        if (mergeObject == null) {
            return;
        }
        Class<?> myclass = this.getClass();
        Field[] fields = myclass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            int modifier = f.getModifiers();
            if (Modifier.isPrivate(modifier) || Modifier.isStatic(modifier) || Modifier.isInterface(modifier)) continue;
            Class<?> fieldType = f.getType();
            String fieldName = f.getName();
            String fname = fieldType.toString();
            try {
                if (fieldType.isPrimitive()) {
                    if (fname.compareTo("int") == 0) {
                        int intfield = f.getInt(mergeObject);
                        f.setInt(this, intfield);
                        continue;
                    }
                    if (fname.compareTo("short") == 0) {
                        short shortField = f.getShort(mergeObject);
                        f.setShort(this, shortField);
                        continue;
                    }
                    if (fname.compareTo("char") == 0) {
                        char charField = f.getChar(mergeObject);
                        f.setChar(this, charField);
                        continue;
                    }
                    if (fname.compareTo("long") == 0) {
                        long longField = f.getLong(mergeObject);
                        f.setLong(this, longField);
                        continue;
                    }
                    if (fname.compareTo("boolean") == 0) {
                        boolean booleanField = f.getBoolean(mergeObject);
                        f.setBoolean(this, booleanField);
                        continue;
                    }
                    if (fname.compareTo("double") == 0) {
                        double doubleField = f.getDouble(mergeObject);
                        f.setDouble(this, doubleField);
                        continue;
                    }
                    if (fname.compareTo("float") != 0) continue;
                    float floatField = f.getFloat(mergeObject);
                    f.setFloat(this, floatField);
                    continue;
                }
                Object obj = f.get(this);
                Object mobj = f.get(mergeObject);
                if (mobj == null) continue;
                if (obj == null) {
                    f.set(this, mobj);
                    continue;
                }
                if (obj instanceof GenericObject) {
                    GenericObject gobj = (GenericObject)obj;
                    gobj.merge(mobj);
                    continue;
                }
                if (obj instanceof GenericObjectList) {
                    GenericObjectList gobjList = (GenericObjectList)obj;
                    gobjList.mergeObjects((GenericObjectList)mobj);
                    continue;
                }
                f.set(this, mobj);
                continue;
            }
            catch (IllegalAccessException ex1) {
                ex1.printStackTrace();
            }
        }
    }

    protected MessageObject() {
    }

    public String dbgPrint(int indent) {
        int save = this.indentation;
        this.indentation = indent;
        String retval = this.toString();
        this.indentation = save;
        return retval;
    }
}

