/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.versioning;

import com.voxeo.versioning.AComponent;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Module
extends AComponent {
    private static final long serialVersionUID = -8037022876732910286L;
    private final String name;
    private final String version;
    private final String date;
    private String memory;
    private String stackTrace;

    public Module(String name, String version, String date) {
        this.name = name;
        this.version = version;
        this.date = date;
    }

    public static Module parseXML(InputStream is) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document document = factory.newDocumentBuilder().parse(is);
        return Module.parseXML(document.getDocumentElement());
    }

    public static Module parseXML(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document document = factory.newDocumentBuilder().parse(new InputSource(new StringReader(xml)));
        return Module.parseXML(document.getDocumentElement());
    }

    protected static Module parseXML(Element documentElement) throws Exception {
        String name = documentElement.getAttribute("name");
        String version = documentElement.getAttribute("version");
        String date = documentElement.getAttribute("date");
        Module module = new Module(name, version, date);
        NodeList nodes = documentElement.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node item = nodes.item(i);
            Element element = (Element)item;
            if ("module".equals(element.getTagName())) {
                module.addComponent(Module.parseXML(element));
                continue;
            }
            if ("memory".equals(element.getTagName())) {
                module.memory = element.getTextContent();
                continue;
            }
            if (!"stacktrace".equals(element.getTagName())) continue;
            module.stackTrace = element.getTextContent();
        }
        return module;
    }

    public String toXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<module name=\"" + this.name + "\" version=\"" + this.version + "\" date=\"" + this.date + "\">");
        if (this.getComponents().size() > 0) {
            Iterator<AComponent> iterator = this.getComponents().iterator();
            while (iterator.hasNext()) {
                sb.append(iterator.next().toXML());
            }
        }
        if (this.memory != null) {
            sb.append("<memory>");
            sb.append("<![CDATA[");
            sb.append(this.memory);
            sb.append("]]>");
            sb.append("</memory>");
        }
        if (this.stackTrace != null) {
            sb.append("<stacktrace>");
            sb.append("<![CDATA[");
            sb.append("\r\n");
            sb.append(this.stackTrace);
            sb.append("\r\n");
            sb.append("]]>");
            sb.append("</stacktrace>");
        }
        sb.append("</module>");
        return sb.toString();
    }

    public String getVersion() {
        return this.version;
    }

    public String getDate() {
        return this.date;
    }

    public String getName() {
        return this.name;
    }

    public void setMemory(String memory) {
        this.memory = memory;
    }

    public String getMemory() {
        return this.memory;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }
}

