/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import com.voxeo.utils.BigDecimals;
import com.voxeo.utils.Objects;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Aggregates {
    private int scale = 2;
    private boolean keepHistory = true;
    private final String[] dimensions;
    private Map data = new HashMap();

    public Aggregates(String[] dimensions) {
        this(dimensions, true);
    }

    public Aggregates(String[] dimensions, boolean keepHistory) {
        this.dimensions = dimensions;
        this.keepHistory = keepHistory;
    }

    public Aggregates(Collection<String> dimensions) {
        this(dimensions.toArray(new String[dimensions.size()]));
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public Set<Object> getValuesInDimension(String dim) {
        TreeSet<Object> r = new TreeSet<Object>();
        int dimIndex = Objects.indexOf(this.dimensions, dim);
        if (dimIndex >= 0) {
            this.addKeys(this.data, 0, dimIndex, r);
        }
        return r;
    }

    private void addKeys(Map map, int currentDepth, int targetDepth, Set<Object> keys) {
        if (currentDepth == targetDepth) {
            keys.addAll(map.keySet());
        } else {
            for (Object object : map.values()) {
                Map childMap = (Map)object;
                this.addKeys(childMap, currentDepth + 1, targetDepth, keys);
            }
        }
    }

    public void add(Map<String, Object> fields, Number value) {
        Item item = this.getItem(fields);
        if (this.keepHistory) {
            item.elements.add(BigDecimals.valueOf(value));
        }
        item.sum = item.sum.add(BigDecimals.valueOf(value));
        item.count = item.count.add(BigDecimal.ONE);
    }

    public void add(Object[] fields, Number value) {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        int idx = 0;
        for (String dim : this.dimensions) {
            fieldMap.put(dim, fields[idx++]);
        }
        this.add(fieldMap, value);
    }

    public void add(List<Object> fields, Number value) {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        int idx = 0;
        for (String dim : this.dimensions) {
            fieldMap.put(dim, fields.get(idx++));
        }
        this.add(fieldMap, value);
    }

    private Item getItem(Map<String, Object> fields) {
        Map map = this.getNextToLastMap(fields);
        Object valueInDim = null;
        valueInDim = fields.get(this.dimensions[this.dimensions.length - 1]);
        Item item = (Item)map.get(valueInDim);
        if (item == null) {
            item = new Item();
            map.put(valueInDim, item);
        }
        return item;
    }

    private Map getNextToLastMap(Map<String, Object> fields) {
        Map map = this.data;
        int i = 0;
        while (i + 1 < this.dimensions.length) {
            String dim = this.dimensions[i];
            Object valueInDim = fields.get(dim);
            HashMap nextMap = (HashMap)map.get(valueInDim);
            if (nextMap == null) {
                nextMap = new HashMap();
                map.put(valueInDim, nextMap);
            }
            map = nextMap;
            ++i;
        }
        return map;
    }

    private Map<String, Object> wrap(List<Object> fields) {
        HashMap<String, Object> r = new HashMap<String, Object>();
        int idx = 0;
        for (String dim : this.dimensions) {
            if (idx >= fields.size()) continue;
            r.put(dim, fields.get(idx++));
        }
        return r;
    }

    public BigDecimal sum(Map<String, Object> fields) {
        return this.selectItem(fields, (Map)this.data, (int)0).sum.setScale(this.scale, RoundingMode.HALF_UP);
    }

    public BigDecimal sum(List<Object> fields) {
        return this.sum(this.wrap(fields));
    }

    public BigDecimal count(Map<String, Object> fields) {
        return this.selectItem(fields, (Map)this.data, (int)0).count.setScale(this.scale, RoundingMode.HALF_UP);
    }

    public BigDecimal count(List<Object> fields) {
        return this.count(this.wrap(fields));
    }

    public List<BigDecimal> values(Map<String, Object> fields) {
        return this.selectItem(fields, (Map)this.data, (int)0).elements;
    }

    public List<BigDecimal> values(List<Object> fields) {
        return this.values(this.wrap(fields));
    }

    public BigDecimal mean(Map<String, Object> fields) {
        return this.selectItem(fields, this.data, 0).mean().setScale(this.scale, RoundingMode.HALF_UP);
    }

    public BigDecimal mean(List<Object> fields) {
        return this.mean(this.wrap(fields));
    }

    public BigDecimal stddev(Map<String, Object> fields) {
        return this.selectItem(fields, this.data, 0).stddev().setScale(this.scale, RoundingMode.HALF_UP);
    }

    public BigDecimal stddev(List<Object> fields) {
        return this.stddev(this.wrap(fields));
    }

    public BigDecimal median(Map<String, Object> fields) {
        return this.selectItem(fields, this.data, 0).median().setScale(this.scale, RoundingMode.HALF_UP);
    }

    public BigDecimal median(List<Object> fields) {
        return this.median(this.wrap(fields));
    }

    public BigDecimal max(Map<String, Object> fields) {
        return this.selectItem(fields, this.data, 0).max().setScale(this.scale, RoundingMode.HALF_UP);
    }

    public BigDecimal max(List<Object> fields) {
        return this.max(this.wrap(fields));
    }

    public BigDecimal min(Map<String, Object> fields) {
        return this.selectItem(fields, this.data, 0).min().setScale(this.scale, RoundingMode.HALF_UP);
    }

    public BigDecimal min(List<Object> fields) {
        return this.min(this.wrap(fields));
    }

    private Item selectItem(Map<String, Object> fields, Map currentMap, int dimIndex) {
        Item r = null;
        Object valueInDim = fields.get(this.dimensions[dimIndex]);
        if (currentMap != null) {
            if (dimIndex + 1 == this.dimensions.length) {
                if (valueInDim == null) {
                    r = new Item();
                    for (Object o : currentMap.values()) {
                        Item item = (Item)o;
                        r.add(item);
                    }
                } else {
                    r = (Item)currentMap.get(valueInDim);
                }
            } else if (valueInDim == null) {
                r = new Item();
                for (Object o : currentMap.values()) {
                    Map map = (Map)o;
                    r.add(this.selectItem(fields, map, dimIndex + 1));
                }
            } else {
                Map nextMap = (Map)currentMap.get(valueInDim);
                r = this.selectItem(fields, nextMap, dimIndex + 1);
            }
        }
        return Objects.isNull(r, new Item());
    }

    private class Item {
        BigDecimal sum = BigDecimal.ZERO;
        BigDecimal count = BigDecimal.ZERO;
        List<BigDecimal> elements = new LinkedList<BigDecimal>();

        private Item() {
        }

        public BigDecimal mean() {
            return this.count.compareTo(BigDecimal.ZERO) > 0 ? this.sum.divide(this.count, RoundingMode.HALF_UP) : BigDecimal.ZERO;
        }

        public BigDecimal stddev() {
            BigDecimal r = BigDecimal.ZERO;
            BigDecimal mean = this.mean();
            for (BigDecimal value : this.elements) {
                r = r.add(value.add(mean.negate()).pow(2));
            }
            r = r.divide(this.count, RoundingMode.HALF_UP);
            return BigDecimals.valueOf(Math.sqrt(r.doubleValue()));
        }

        public BigDecimal median() {
            if (this.elements.size() > 0) {
                ArrayList<BigDecimal> list = new ArrayList<BigDecimal>(this.elements);
                Collections.sort(list);
                return (BigDecimal)list.get(list.size() / 2);
            }
            return BigDecimal.ZERO;
        }

        public BigDecimal min() {
            BigDecimal min = null;
            for (BigDecimal element : this.elements) {
                if (min != null && element.compareTo(min) >= 0) continue;
                min = element;
            }
            return Objects.isNull(min, BigDecimals.valueOf(0));
        }

        public BigDecimal max() {
            BigDecimal max = null;
            for (BigDecimal element : this.elements) {
                if (max != null && element.compareTo(max) <= 0) continue;
                max = element;
            }
            return Objects.isNull(max, BigDecimals.valueOf(0));
        }

        void add(Item item) {
            if (item != null) {
                this.count = this.count.add(item.count);
                this.sum = this.sum.add(item.sum);
                if (Aggregates.this.keepHistory) {
                    this.elements.addAll(item.elements);
                }
            }
        }
    }
}

