/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.restrictor;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import org.jolokia.config.ConfigKey;
import org.jolokia.config.Configuration;
import org.jolokia.restrictor.AllowAllRestrictor;
import org.jolokia.restrictor.DenyAllRestrictor;
import org.jolokia.restrictor.PolicyRestrictor;
import org.jolokia.restrictor.Restrictor;
import org.jolokia.util.ClassUtil;
import org.jolokia.util.LogHandler;
import org.jolokia.util.NetworkUtil;

public final class RestrictorFactory {
    private RestrictorFactory() {
    }

    public static Restrictor createRestrictor(Configuration pConfig, LogHandler logHandler) {
        Restrictor customRestrictor = RestrictorFactory.createCustomRestrictor(pConfig);
        if (customRestrictor != null) {
            logHandler.info("Using restrictor " + customRestrictor.getClass().getCanonicalName());
            return customRestrictor;
        }
        String location = NetworkUtil.replaceExpression(pConfig.get(ConfigKey.POLICY_LOCATION));
        try {
            PolicyRestrictor ret = RestrictorFactory.lookupPolicyRestrictor(location);
            if (ret != null) {
                logHandler.info("Using policy access restrictor " + location);
                return ret;
            }
            logHandler.info("No access restrictor found, access to any MBean is allowed");
            return new AllowAllRestrictor();
        }
        catch (IOException e) {
            logHandler.error("Error while accessing access restrictor at " + location + ". Denying all access to MBeans for security reasons. Exception: " + e, e);
            return new DenyAllRestrictor();
        }
    }

    private static Restrictor createCustomRestrictor(Configuration pConfig) {
        String restrictorClassName = pConfig.get(ConfigKey.RESTRICTOR_CLASS);
        if (restrictorClassName == null) {
            return null;
        }
        Class restrictorClass = ClassUtil.classForName(restrictorClassName, new ClassLoader[0]);
        if (restrictorClass == null) {
            throw new IllegalArgumentException("No custom restrictor class " + restrictorClassName + " found");
        }
        return RestrictorFactory.lookupRestrictor(pConfig, restrictorClass);
    }

    private static Restrictor lookupRestrictor(Configuration pConfig, Class restrictorClass) {
        try {
            try {
                Constructor ctr = restrictorClass.getConstructor(Configuration.class);
                return (Restrictor)ctr.newInstance(pConfig);
            }
            catch (NoSuchMethodException exp) {
                try {
                    Constructor defaultConstructor = restrictorClass.getConstructor(new Class[0]);
                    return (Restrictor)defaultConstructor.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException exp2) {
                    throw new IllegalArgumentException("Cannot create custom restrictor for class " + restrictorClass + " " + "because neither a constructor with 'Configuration' as only element " + "nor a default constructor is available");
                }
            }
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("Cannot create an instance of custom restrictor class " + restrictorClass, e);
        }
    }

    public static PolicyRestrictor lookupPolicyRestrictor(String pLocation) throws IOException {
        InputStream is;
        if (pLocation.startsWith("classpath:")) {
            String path = pLocation.substring("classpath:".length());
            is = ClassUtil.getResourceAsStream(path);
            if (is == null) {
                is = RestrictorFactory.class.getResourceAsStream(path);
            }
        } else {
            URL url = new URL(pLocation);
            is = url.openStream();
        }
        return is != null ? new PolicyRestrictor(is) : null;
    }
}

