/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.request;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.management.MalformedObjectNameException;
import org.jolokia.config.ProcessingParameters;
import org.jolokia.converter.object.StringToObjectConverter;
import org.jolokia.request.JmxObjectNameRequest;
import org.jolokia.request.RequestCreator;
import org.jolokia.util.RequestType;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxExecRequest
extends JmxObjectNameRequest {
    private String operation;
    private List arguments;

    JmxExecRequest(String pObjectName, String pOperation, List pArguments, ProcessingParameters pParams) throws MalformedObjectNameException {
        super(RequestType.EXEC, pObjectName, null, pParams);
        this.operation = pOperation;
        this.arguments = pArguments;
    }

    JmxExecRequest(Map<String, ?> pRequestMap, ProcessingParameters pParams) throws MalformedObjectNameException {
        super(pRequestMap, pParams);
        this.arguments = (List)pRequestMap.get("arguments");
        this.operation = (String)pRequestMap.get("operation");
    }

    public String getOperation() {
        return this.operation;
    }

    public List getArguments() {
        return this.arguments;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject ret = super.toJSON();
        if (this.arguments != null && this.arguments.size() > 0) {
            ret.put((Object)"arguments", (Object)this.arguments);
        }
        ret.put((Object)"operation", (Object)this.operation);
        return ret;
    }

    static RequestCreator<JmxExecRequest> newCreator() {
        return new RequestCreator<JmxExecRequest>(){

            @Override
            public JmxExecRequest create(Stack<String> pStack, ProcessingParameters pParams) throws MalformedObjectNameException {
                return new JmxExecRequest(pStack.pop(), pStack.pop(), JmxExecRequest.convertSpecialStringTags(this.prepareExtraArgs(pStack)), pParams);
            }

            @Override
            public JmxExecRequest create(Map<String, ?> requestMap, ProcessingParameters pParams) throws MalformedObjectNameException {
                return new JmxExecRequest(requestMap, pParams);
            }
        };
    }

    private static List<String> convertSpecialStringTags(List<String> extraArgs) {
        if (extraArgs == null) {
            return null;
        }
        ArrayList<String> args = new ArrayList<String>();
        for (String arg : extraArgs) {
            args.add(StringToObjectConverter.convertSpecialStringTags(arg));
        }
        return args;
    }

    public String toString() {
        String baseInfo;
        StringBuffer ret = new StringBuffer("JmxExecRequest[");
        ret.append("operation=").append(this.getOperation());
        if (this.arguments != null && this.arguments.size() > 0) {
            ret.append(", arguments=").append(this.getArguments());
        }
        if ((baseInfo = this.getInfo()) != null) {
            ret.append(", ").append(baseInfo);
        }
        ret.append("]");
        return ret.toString();
    }
}

